/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.event;

import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.ArrayList;
import java.util.List;

public class SimpleEventListenerList {
    private List<SimpleEventListener> list = new ArrayList<SimpleEventListener>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(SimpleEventListener simpleEventListener) {
        ValidationHelper.checkForNull("Listener", simpleEventListener);
        List<SimpleEventListener> list = this.list;
        synchronized (list) {
            if (this.list.contains(simpleEventListener)) {
                return;
            }
            this.list.add(simpleEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<SimpleEventListener> list = this.list;
        synchronized (list) {
            this.list.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleEventListener[] getListeners() {
        SimpleEventListener[] simpleEventListenerArray = null;
        List<SimpleEventListener> list = this.list;
        synchronized (list) {
            simpleEventListenerArray = new SimpleEventListener[this.list.size()];
            this.list.toArray(simpleEventListenerArray);
        }
        return simpleEventListenerArray;
    }

    public String getInfoHTML() {
        SimpleEventListener[] simpleEventListenerArray = this.getListeners();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<table border=\"1\" bordercolor=\"gray\" cellspacing=\"0\">\n");
        if (simpleEventListenerArray.length == 0) {
            stringBuffer.append("<tr><td>None.</td></tr>\n");
        } else {
            stringBuffer.append("<tr><td><b>Classname</b></td><td><b>Implementation</b></td></tr>\n");
            for (int i = 0; i < simpleEventListenerArray.length; ++i) {
                stringBuffer.append("<tr><td>");
                stringBuffer.append(simpleEventListenerArray[i].getClass().getName());
                stringBuffer.append("</td><td>");
                stringBuffer.append(simpleEventListenerArray[i].toString());
                stringBuffer.append("</td></tr>\n");
            }
        }
        stringBuffer.append("</table>\n");
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeListener(SimpleEventListener simpleEventListener) {
        ValidationHelper.checkForNull("Listener", simpleEventListener);
        List<SimpleEventListener> list = this.list;
        synchronized (list) {
            return this.list.remove(simpleEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(GenericEvent genericEvent) {
        ValidationHelper.checkForNull("Event", genericEvent);
        List<SimpleEventListener> list = this.list;
        synchronized (list) {
            for (SimpleEventListener simpleEventListener : this.list) {
                simpleEventListener.serviceEvent(genericEvent);
            }
        }
    }
}

