/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.event;

import com.helpsystems.common.core.event.GenericEvent;
import com.helpsystems.common.core.event.ShutdownEvent;
import com.helpsystems.common.core.event.SimpleEventListener;
import com.helpsystems.common.core.event.SimpleEventListenerList;
import com.helpsystems.common.core.event.SimpleEventSubject;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class EventQueue
implements SimpleEventSubject {
    private static final Logger logger = Logger.getLogger(EventQueue.class);
    private ArrayList<GenericEvent> eventQueue;
    private SimpleEventListenerList listenerList;
    private boolean innerThreadRunning = false;
    private Object lockObject = new Object();
    private Object initLockObject = new Object();
    private boolean shutdownWhenQueueIsEmpty;
    private Thread eventQueueThread;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventQueue() {
        this.eventQueue = new ArrayList();
        this.listenerList = new SimpleEventListenerList();
        this.eventQueueThread = new EventQueueThread();
        this.setThreadName(null);
        this.eventQueueThread.setPriority(7);
        this.eventQueueThread.start();
        logger.trace((Object)"Our EventQueue is being started.");
        Object object = this.initLockObject;
        synchronized (object) {
            try {
                if (!this.innerThreadRunning) {
                    this.initLockObject.wait();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEvent(GenericEvent genericEvent, boolean bl) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Event: " + genericEvent));
        }
        Object object = this.eventQueue;
        synchronized (object) {
            this.eventQueue.add(genericEvent);
        }
        object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
        if (bl) {
            while (!genericEvent.hasBeenServiced()) {
                try {
                    object = genericEvent;
                    synchronized (object) {
                        genericEvent.wait();
                    }
                }
                catch (InterruptedException interruptedException) {
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(SimpleEventListener simpleEventListener) {
        SimpleEventListenerList simpleEventListenerList = this.listenerList;
        synchronized (simpleEventListenerList) {
            this.listenerList.addListener(simpleEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleEventListener[] getListeners() {
        SimpleEventListenerList simpleEventListenerList = this.listenerList;
        synchronized (simpleEventListenerList) {
            return this.listenerList.getListeners();
        }
    }

    public String getInfoHTML() {
        return this.listenerList.getInfoHTML();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SimpleEventListener removeListener(SimpleEventListener simpleEventListener) {
        SimpleEventListenerList simpleEventListenerList = this.listenerList;
        synchronized (simpleEventListenerList) {
            if (this.listenerList.removeListener(simpleEventListener)) {
                return simpleEventListener;
            }
            return null;
        }
    }

    public void setThreadName(String string) {
        String string2 = "EventQueue Thread";
        if (string != null && string.length() > 0) {
            string2 = string2 + " - " + string;
        }
        this.eventQueueThread.setName(string2);
    }

    class EventQueueThread
    extends Thread {
        EventQueueThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            GenericEvent genericEvent = null;
            SimpleEventListener[] simpleEventListenerArray = null;
            Object object = EventQueue.this.initLockObject;
            synchronized (object) {
                EventQueue.this.innerThreadRunning = true;
                EventQueue.this.initLockObject.notifyAll();
            }
            try {
                while (true) {
                    genericEvent = null;
                    object = EventQueue.this.eventQueue;
                    synchronized (object) {
                        if (EventQueue.this.eventQueue.size() > 0) {
                            genericEvent = (GenericEvent)EventQueue.this.eventQueue.get(0);
                            EventQueue.this.eventQueue.remove(0);
                        }
                    }
                    if (genericEvent == null) {
                        if (EventQueue.this.shutdownWhenQueueIsEmpty) {
                            return;
                        }
                        object = EventQueue.this.lockObject;
                        synchronized (object) {
                            try {
                                EventQueue.this.lockObject.wait(500L);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                    simpleEventListenerArray = EventQueue.this.getListeners();
                    if (simpleEventListenerArray != null) {
                        for (int i = 0; i < simpleEventListenerArray.length; ++i) {
                            try {
                                simpleEventListenerArray[i].serviceEvent(genericEvent);
                                continue;
                            }
                            catch (Exception exception) {
                                logger.debug((Object)("The Event Listener " + simpleEventListenerArray[i] + " threw an exception on" + " event: " + genericEvent), (Throwable)exception);
                            }
                        }
                    }
                    genericEvent.setServiced(true);
                    object = genericEvent;
                    synchronized (object) {
                        genericEvent.notifyAll();
                    }
                    if (!(genericEvent instanceof ShutdownEvent)) continue;
                    EventQueue.this.shutdownWhenQueueIsEmpty = true;
                }
            }
            catch (Throwable throwable) {
                logger.error((Object)"The EventQueue thread ended in error.", throwable);
                return;
            }
        }
    }
}

