/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.encryption;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.dm.EncryptUtilAM;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;

public abstract class EncryptUtil
extends AbstractManager
implements EncryptUtilAM {
    private static final Logger logger = Logger.getLogger(EncryptUtil.class);
    private Cipher decodeCipher;
    private Cipher encodeCipher;
    private static Charset UTF8_CHARSET;
    private static final char[] BASE_32_ALPHABET;
    private static final Map<Character, Integer> BASE_32_MAP;

    protected EncryptUtil(Cipher cipher, Cipher cipher2) {
        this.encodeCipher = cipher;
        this.decodeCipher = cipher2;
    }

    private static void checkUTF8Charset() {
        if (UTF8_CHARSET == null) {
            throw new NullPointerException("Unable to process data, the UTF-8 Charset is null.");
        }
    }

    public String decode(String string) {
        try {
            byte[] byArray = new byte[string.length() / 2];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = (byte)Integer.parseInt(string.substring(i * 2, i * 2 + 2), 16);
            }
            byte[] byArray2 = this.decodeBinary(byArray);
            String string2 = new String(byArray2);
            return string2;
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to decode the string.", exception);
        }
    }

    public byte[] decodeBase64(String string) throws IOException, IllegalBlockSizeException, BadPaddingException {
        byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
        return this.decodeBinary(byArray);
    }

    @Override
    public char[] decodeBase64ToChar(String string) throws ActionFailedException {
        try {
            byte[] byArray = this.decodeBase64(string);
            return EncryptUtil.convertUTF8ByteToChar(byArray);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to decode the data", exception);
        }
    }

    @Override
    public char[] decodeHexToChar(String string) throws ActionFailedException {
        try {
            return this.decode(string).toCharArray();
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to decode the data", exception);
        }
    }

    public static char[] convertUTF8ByteToChar(byte[] byArray) throws IOException {
        int n;
        EncryptUtil.checkUTF8Charset();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        InputStreamReader inputStreamReader = new InputStreamReader((InputStream)byteArrayInputStream, UTF8_CHARSET);
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        char[] cArray = new char[1000];
        while ((n = inputStreamReader.read(cArray, 0, cArray.length)) != -1) {
            charArrayWriter.write(cArray, 0, n);
        }
        charArrayWriter.flush();
        return charArrayWriter.toCharArray();
    }

    public static byte[] convertCharToUTF8Byte(char[] cArray) throws IOException {
        EncryptUtil.checkUTF8Charset();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)byteArrayOutputStream, UTF8_CHARSET);
        outputStreamWriter.write(cArray, 0, cArray.length);
        outputStreamWriter.flush();
        byteArrayOutputStream.flush();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] decodeBinary(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return this.decodeCipher.doFinal(byArray);
    }

    public byte[] encodeBinary(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        return this.encodeCipher.doFinal(byArray);
    }

    public String encodeBinaryToBase64(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        byte[] byArray2 = this.encodeBinary(byArray);
        String string = DatatypeConverter.printBase64Binary((byte[])byArray2);
        string = string.replaceAll("[\r\n]", "");
        return string;
    }

    @Override
    public String encodeCharToBase64(char[] cArray) throws ActionFailedException {
        try {
            byte[] byArray = EncryptUtil.convertCharToUTF8Byte(cArray);
            return this.encodeBinaryToBase64(byArray);
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to encode the data.", exception);
        }
    }

    @Override
    public String encodeCharToHex(char[] cArray) throws ActionFailedException {
        try {
            return this.encode(new String(cArray));
        }
        catch (Exception exception) {
            throw new ActionFailedException("Unable to encode the data.", exception);
        }
    }

    public String encode(String string) {
        try {
            byte[] byArray = string.getBytes();
            byte[] byArray2 = this.encodeBinary(byArray);
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < byArray2.length; ++i) {
                String string2;
                int n = byArray2[i];
                if (n < 0) {
                    n += 256;
                }
                if ((string2 = Integer.toHexString(n)).length() < 2) {
                    stringBuffer.append('0');
                }
                stringBuffer.append(string2);
            }
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to encode the string.", exception);
        }
    }

    public String encodeBinaryToBase32(byte[] byArray) throws IllegalBlockSizeException, BadPaddingException {
        int n;
        byte[] byArray2 = this.encodeBinary(byArray);
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; n3 < byArray2.length || i > 0; i -= 5) {
            if (i < 5 && n3 < byArray2.length) {
                n = byArray2[n3];
                if (n < 0) {
                    n += 256;
                }
                n2 |= (n <<= 24 - i);
                ++n3;
                i += 8;
            }
            n = n2 >>> 27;
            stringBuffer.append(BASE_32_ALPHABET[n]);
            n2 <<= 5;
        }
        n = stringBuffer.charAt(0);
        for (n2 = 1; n2 < stringBuffer.length(); ++n2) {
            char c = stringBuffer.charAt(n2);
            if (c == n) {
                char c2 = c % 2 == 0 ? (char)'+' : '*';
                stringBuffer.setCharAt(n2, c2);
            }
            n = c;
        }
        return stringBuffer.toString();
    }

    public byte[] decodeBase32ToBinary(String string) throws IllegalBlockSizeException, BadPaddingException {
        int n;
        String string2 = string;
        if (string2 == null) {
            throw new NullPointerException("Null input");
        }
        if (string2.length() == 0) {
            return new byte[0];
        }
        StringBuffer stringBuffer = new StringBuffer(string2);
        int n2 = stringBuffer.charAt(0);
        for (int i = 1; i < stringBuffer.length(); ++i) {
            n = stringBuffer.charAt(i);
            if (n == 43 || n == 42) {
                stringBuffer.setCharAt(i, (char)n2);
                continue;
            }
            n2 = n;
        }
        string2 = stringBuffer.toString();
        byte[] byArray = new byte[string2.length()];
        n = 0;
        int n3 = 0;
        int n4 = 0;
        for (int i = 0; i < string2.length(); ++i) {
            byte by;
            char c = string2.charAt(i);
            Integer n5 = BASE_32_MAP.get(new Character(c));
            if (n5 == null) {
                throw new IllegalArgumentException("The char " + c + " is not allowed.");
            }
            int n6 = n5;
            n3 |= n6 << 27 - n4;
            if ((n4 += 5) < 8) continue;
            byArray[n] = by = (byte)(n3 >>> 24);
            ++n;
            n3 <<= 8;
            n4 -= 8;
        }
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, n);
        return this.decodeBinary(byArray2);
    }

    public static String cleanBeforeDecode(String string) {
        if (string == null) {
            return string;
        }
        return string.toUpperCase().replace('I', '1').replace('O', '0').replace('S', '5');
    }

    public static String cleanAfterEncode(String string) {
        if (string == null) {
            return string;
        }
        return string.toUpperCase().replace('I', 'X').replace('O', 'Z').replace('S', 'W');
    }

    static {
        BASE_32_ALPHABET = new char[32];
        BASE_32_MAP = new HashMap<Character, Integer>(64);
        for (int i = 0; i < BASE_32_ALPHABET.length; ++i) {
            EncryptUtil.BASE_32_ALPHABET[i] = i < 10 ? (char)(48 + i) : (char)(65 + (i - 10));
            BASE_32_MAP.put(new Character(BASE_32_ALPHABET[i]), new Integer(i));
            switch (BASE_32_ALPHABET[i]) {
                case 'O': {
                    EncryptUtil.BASE_32_ALPHABET[i] = 90;
                    break;
                }
                case 'S': {
                    EncryptUtil.BASE_32_ALPHABET[i] = 87;
                    break;
                }
                case 'I': {
                    EncryptUtil.BASE_32_ALPHABET[i] = 88;
                }
            }
            BASE_32_MAP.put(new Character(BASE_32_ALPHABET[i]), new Integer(i));
        }
        try {
            UTF8_CHARSET = Charset.forName("UTF-8");
        }
        catch (Exception exception) {
            logger.warn((Object)"Unable to find a UTF-8 charset.", (Throwable)exception);
        }
    }
}

