/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.console;

import com.helpsystems.common.core.console.MessageCenterMessage;
import junit.framework.TestCase;

public class MessageCenterMessageTest
extends TestCase {
    MessageCenterMessage mess;

    protected void setUp() throws Exception {
        super.setUp();
        this.mess = new MessageCenterMessage();
    }

    protected void tearDown() throws Exception {
        this.mess = null;
        super.tearDown();
    }

    public void testConstructorCenterAndText() {
        this.mess = new MessageCenterMessage("msg_ctr", "message_text");
        MessageCenterMessageTest.assertEquals((String)"msg_ctr", (String)this.mess.getMessageCenter());
        MessageCenterMessageTest.assertEquals((String)"message_text", (String)this.mess.getMessageText());
        MessageCenterMessageTest.assertFalse((boolean)this.mess.getResponseRequired());
    }

    public void testConstructorCenterTextResponseRequired() {
        this.mess = new MessageCenterMessage("msg_ctr", "message_text", true);
        MessageCenterMessageTest.assertEquals((String)"msg_ctr", (String)this.mess.getMessageCenter());
        MessageCenterMessageTest.assertEquals((String)"message_text", (String)this.mess.getMessageText());
        MessageCenterMessageTest.assertTrue((boolean)this.mess.getResponseRequired());
    }

    public void testBuildSndMsgCommand() {
        this.mess.setMessageCenter("msg_ctr");
        this.mess.setMessageText("message_text");
        String string = this.mess.buildSndMsgCommand();
        String string2 = "SENDMC MSG('message_text') MSGCTR(msg_ctr)";
        MessageCenterMessageTest.assertEquals((String)string2, (String)string);
    }

    public void testBuildSndMsgCommandRequiresMessageCenter() {
        this.mess.setMessageText("message_text");
        try {
            this.mess.buildSndMsgCommand();
            MessageCenterMessageTest.fail((String)"buildSndMsgCommand() didn't require Message Center");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testBuildSndMsgCommandRequiresMessageText() {
        this.mess.setMessageCenter("msg_ctr");
        try {
            this.mess.buildSndMsgCommand();
            MessageCenterMessageTest.fail((String)"buildSndMsgCommand() didn't require Message Text");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void testGetMessageCenter() {
        this.mess.setMessageCenter("msg_ctr");
        MessageCenterMessageTest.assertEquals((String)"msg_ctr", (String)this.mess.getMessageCenter());
    }

    public void testGetMessageText() {
        this.mess.setMessageText("message_text");
        MessageCenterMessageTest.assertEquals((String)"message_text", (String)this.mess.getMessageText());
    }

    public void testGetResponseRequired() {
        this.mess.setResponseRequired(true);
        MessageCenterMessageTest.assertTrue((boolean)this.mess.getResponseRequired());
        this.mess.setResponseRequired(false);
        MessageCenterMessageTest.assertFalse((boolean)this.mess.getResponseRequired());
    }
}

