/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.TimeOfDay;
import junit.framework.TestCase;

public class TimeOfDayTest
extends TestCase {
    TimeOfDay tod;

    protected void setUp() throws Exception {
        super.setUp();
        this.tod = new TimeOfDay();
    }

    protected void tearDown() throws Exception {
        this.tod = null;
        super.tearDown();
    }

    public void testConstructors() {
        this.tod = new TimeOfDay(12, 34, 56, -8);
        TimeOfDayTest.assertEquals((int)12, (int)this.tod.getHour());
        TimeOfDayTest.assertEquals((int)34, (int)this.tod.getMinute());
        TimeOfDayTest.assertEquals((int)56, (int)this.tod.getSecond());
        TimeOfDayTest.assertEquals((int)-8, (int)this.tod.getTimezone());
        this.tod = new TimeOfDay(11, 12, 13);
        TimeOfDayTest.assertEquals((int)11, (int)this.tod.getHour());
        TimeOfDayTest.assertEquals((int)12, (int)this.tod.getMinute());
        TimeOfDayTest.assertEquals((int)13, (int)this.tod.getSecond());
        TimeOfDayTest.assertEquals((int)-9999, (int)this.tod.getTimezone());
        this.tod = new TimeOfDay(2345, -7);
        TimeOfDayTest.assertEquals((int)23, (int)this.tod.getHour());
        TimeOfDayTest.assertEquals((int)45, (int)this.tod.getMinute());
        TimeOfDayTest.assertEquals((int)0, (int)this.tod.getSecond());
        TimeOfDayTest.assertEquals((int)-7, (int)this.tod.getTimezone());
        this.tod = new TimeOfDay(1234);
        TimeOfDayTest.assertEquals((int)12, (int)this.tod.getHour());
        TimeOfDayTest.assertEquals((int)34, (int)this.tod.getMinute());
        TimeOfDayTest.assertEquals((int)0, (int)this.tod.getSecond());
        TimeOfDayTest.assertEquals((int)-9999, (int)this.tod.getTimezone());
    }

    public void testEqualsObject() {
        TimeOfDayTest.assertFalse((boolean)this.tod.equals(null));
        try {
            this.tod.equals(new Object());
            TimeOfDayTest.fail((String)"equals(Object) allowed for non-TimeOfDay object");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TimeOfDayTest.assertTrue((boolean)this.tod.equals(this.tod));
        TimeOfDay timeOfDay = new TimeOfDay(1234, -6);
        TimeOfDay timeOfDay2 = new TimeOfDay(1234, -7);
        TimeOfDay timeOfDay3 = new TimeOfDay(1234);
        TimeOfDay timeOfDay4 = new TimeOfDay(2345);
        TimeOfDayTest.assertEquals((Object)timeOfDay, (Object)timeOfDay2);
        TimeOfDayTest.assertEquals((Object)timeOfDay3, (Object)timeOfDay2);
        TimeOfDayTest.assertEquals((Object)timeOfDay3, (Object)timeOfDay);
        TimeOfDayTest.assertFalse((boolean)timeOfDay3.equals(timeOfDay4));
        TimeOfDayTest.assertFalse((boolean)timeOfDay4.equals(timeOfDay3));
    }

    public void testGetCurrentTimeOfDay() {
        TimeOfDay timeOfDay = TimeOfDay.getCurrentTimeOfDay();
        TimeOfDayTest.assertFalse((timeOfDay.getHHMMSS() == 0 ? 1 : 0) != 0);
    }

    public void testCompareTo() {
        TimeOfDay timeOfDay = TimeOfDay.getCurrentTimeOfDay();
        timeOfDay.setSecond(0);
        TimeOfDay timeOfDay2 = new TimeOfDay(timeOfDay.getHHMM());
        timeOfDay2.setSecond(5);
        try {
            timeOfDay.compareTo(new Object());
            TimeOfDayTest.fail((String)"compareTo(Object) allowed comparison to a non TimeOfDay object");
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        TimeOfDayTest.assertTrue((timeOfDay.compareTo(timeOfDay2) < 0 ? 1 : 0) != 0);
        TimeOfDayTest.assertTrue((timeOfDay2.compareTo(timeOfDay) > 0 ? 1 : 0) != 0);
        TimeOfDayTest.assertTrue((timeOfDay.compareTo(timeOfDay) == 0 ? 1 : 0) != 0);
    }

    public void testIsTimezoneSpecified() {
        TimeOfDayTest.assertFalse((boolean)this.tod.isTimezoneSpecified());
        this.tod.setTimezone(-5);
        TimeOfDayTest.assertTrue((boolean)this.tod.isTimezoneSpecified());
    }

    public void testGetHHMM() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        TimeOfDayTest.assertEquals((int)1235, (int)this.tod.getHHMM());
    }

    public void testGetHHMMSS() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        this.tod.setSecond(9);
        TimeOfDayTest.assertEquals((int)123509, (int)this.tod.getHHMMSS());
    }

    public void testToStringHHMMSSString() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        this.tod.setSecond(9);
        TimeOfDayTest.assertEquals((String)"12:35:09", (String)this.tod.toStringHHMMSS(":"));
        this.tod.setMinute(5);
        this.tod.setSecond(29);
        TimeOfDayTest.assertEquals((String)"12:05:29", (String)this.tod.toStringHHMMSS(":"));
        TimeOfDayTest.assertEquals((String)"120529", (String)this.tod.toStringHHMMSS(null));
    }

    public void testToStringHHMMSS() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        this.tod.setSecond(9);
        TimeOfDayTest.assertEquals((String)"123509", (String)this.tod.toStringHHMMSS());
    }

    public void testToStringHHMMString() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        this.tod.setSecond(9);
        TimeOfDayTest.assertEquals((String)"12:35", (String)this.tod.toStringHHMM(":"));
        this.tod.setHour(1);
        this.tod.setMinute(23);
        this.tod.setSecond(45);
        TimeOfDayTest.assertEquals((String)"0123", (String)this.tod.toStringHHMM(null));
    }

    public void testToStringHHMM() {
        this.tod.setHour(12);
        this.tod.setMinute(35);
        this.tod.setSecond(9);
        TimeOfDayTest.assertEquals((String)"1235", (String)this.tod.toStringHHMM());
    }

    public void testSetHour() {
        for (int i = 0; i < 24; ++i) {
            this.tod.setHour(i);
            TimeOfDayTest.assertEquals((int)i, (int)this.tod.getHour());
        }
    }

    public void testSetHourRejectsInvalidValues() {
        try {
            this.tod.setHour(-1);
            TimeOfDayTest.fail((String)"setHour(int) accepted negative value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tod.setHour(24);
            TimeOfDayTest.fail((String)"setHour(int) accepted too large value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetMinute() {
        for (int i = 0; i < 60; ++i) {
            this.tod.setMinute(i);
            TimeOfDayTest.assertEquals((int)i, (int)this.tod.getMinute());
        }
    }

    public void testSetMinuteRejectsInvalidValues() {
        try {
            this.tod.setMinute(-1);
            TimeOfDayTest.fail((String)"setMinute(int) accepted negative value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tod.setMinute(60);
            TimeOfDayTest.fail((String)"setMinute(int) accepted too large value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetSecond() {
        for (int i = 0; i < 60; ++i) {
            this.tod.setSecond(i);
            TimeOfDayTest.assertEquals((int)i, (int)this.tod.getSecond());
        }
    }

    public void testSetSecondRejectsInvalidValues() {
        try {
            this.tod.setSecond(-1);
            TimeOfDayTest.fail((String)"setSecond(int) accepted negative value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tod.setSecond(60);
            TimeOfDayTest.fail((String)"setSecond(int) accepted too large value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testSetTimezone() {
        for (int i = -23; i < 24; ++i) {
            this.tod.setTimezone(i);
            TimeOfDayTest.assertEquals((int)i, (int)this.tod.getTimezone());
        }
        this.tod.setTimezone(-9999);
        TimeOfDayTest.assertEquals((int)-9999, (int)this.tod.getTimezone());
    }

    public void testSetTimezoneRejectsInvalidValues() {
        try {
            this.tod.setTimezone(-24);
            TimeOfDayTest.fail((String)"setTimezone(int) accepted too small value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.tod.setTimezone(24);
            TimeOfDayTest.fail((String)"setTimezone(int) accepted too large value");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testDoNotInvoke() {
        String[] stringArray = this.tod.doNotInvoke();
        TimeOfDayTest.assertEquals((int)2, (int)stringArray.length);
        TimeOfDayTest.assertTrue((boolean)TimeOfDayTest.arrayContains(stringArray, "getHHMM"));
        TimeOfDayTest.assertTrue((boolean)TimeOfDayTest.arrayContains(stringArray, "getHHMMSS"));
    }

    private static boolean arrayContains(String[] stringArray, String string) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }
}

