/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import com.helpsystems.common.core.util.MessageUtil;
import com.helpsystems.common.core.util.ResourceBundleHandler;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.XMLSerializable;
import java.util.GregorianCalendar;

public class TimeOfDay
extends CommonVersionedObject
implements XMLSerializable,
Comparable {
    private static final ResourceBundleHandler rbh = ResourceBundleHandler.getHandler(TimeOfDay.class);
    public static final int MINIMUM_HOUR = 0;
    public static final int MAXIMUM_HOUR = 23;
    public static final int MINIMUM_MINUTE = 0;
    public static final int MAXIMUM_MINUTE = 59;
    public static final int MINIMUM_SECOND = 0;
    public static final int MAXIMUM_SECOND = 59;
    public static final int MINIMUM_TIMEZONE = -23;
    public static final int MAXIMUM_TIMEZONE = 23;
    public static final int GMT = 0;
    public static final int EST = -5;
    public static final int EDT = -4;
    public static final int CST = -6;
    public static final int CDT = -5;
    public static final int MST = -7;
    public static final int MDT = -6;
    public static final int PST = -8;
    public static final int PDT = -7;
    public static final int TIMEZONE_NOT_SPECIFIED = -9999;
    private static final long serialVersionUID = -4202241995475859388L;
    private int hour;
    private int minute;
    private int second;
    private int timezone;

    public static TimeOfDay getCurrentTimeOfDay() {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        return new TimeOfDay(gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13));
    }

    public int compareTo(Object object) {
        TimeOfDay timeOfDay;
        ValidationHelper.checkForNull("Comparison object", object);
        try {
            timeOfDay = (TimeOfDay)object;
        }
        catch (ClassCastException classCastException) {
            String string = MessageUtil.formatMsg("An attempt was made to compare a(n) {0} object to a TimeOfDay object.", object.getClass().getName());
            throw new RuntimeException(string, classCastException);
        }
        int n = this.getHHMMSS();
        int n2 = timeOfDay.getHHMMSS();
        if (n < n2) {
            return -1;
        }
        if (n > n2) {
            return 1;
        }
        return 0;
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public TimeOfDay() {
        this(0, 0, 0, -9999);
    }

    public TimeOfDay(int n, int n2, int n3) {
        this(n, n2, n3, -9999);
    }

    public TimeOfDay(int n, int n2, int n3, int n4) {
        this.setHour(n);
        this.setMinute(n2);
        this.setSecond(n3);
        this.setTimezone(n4);
    }

    public TimeOfDay(int n) {
        this(n, -9999);
    }

    public TimeOfDay(int n, int n2) {
        this(n / 100, n % 100, 0, n2);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public int getTimezone() {
        return this.timezone;
    }

    public boolean isTimezoneSpecified() {
        return this.timezone != -9999;
    }

    public int getHHMM() {
        return this.hour * 100 + this.minute;
    }

    public int getHHMMSS() {
        return this.hour * 10000 + this.minute * 100 + this.second;
    }

    public String toStringHHMMSS(String string) {
        String string2;
        String string3 = string;
        if (string3 == null) {
            string3 = "";
        }
        if ((string2 = Integer.toString(this.second)).length() == 1) {
            string2 = "0" + string2;
        }
        return this.toStringHHMM(string3) + string3 + string2;
    }

    public String toStringHHMMSS() {
        return this.toStringHHMMSS("");
    }

    public String toStringHHMM(String string) {
        String string2;
        String string3;
        String string4 = string;
        if (string4 == null) {
            string4 = "";
        }
        if ((string3 = Integer.toString(this.hour)).length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toString(this.minute)).length() == 1) {
            string2 = "0" + string2;
        }
        return string3 + string4 + string2;
    }

    public String toStringHHMM() {
        return this.toStringHHMM("");
    }

    public void setHour(int n) {
        if (n < 0 || n > 23) {
            throw new IllegalArgumentException(MessageUtil.formatMsg(rbh.getMsg("hour_outside_range"), Integer.toString(0), Integer.toString(23)));
        }
        this.hour = n;
    }

    public void setMinute(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(MessageUtil.formatMsg(rbh.getMsg("minute_outside_range"), Integer.toString(0), Integer.toString(59)));
        }
        this.minute = n;
    }

    public void setSecond(int n) {
        if (n < 0 || n > 59) {
            throw new IllegalArgumentException(MessageUtil.formatMsg(rbh.getMsg("second_outside_range"), Integer.toString(0), Integer.toString(59)));
        }
        this.second = n;
    }

    public void setTimezone(int n) {
        if ((n > 23 || n < -23) && n != -9999) {
            throw new IllegalArgumentException(MessageUtil.formatMsg(rbh.getMsg("timezone_outside_range"), Integer.toString(-23), Integer.toString(23)));
        }
        this.timezone = n;
    }

    @Override
    public String[] doNotInvoke() {
        return new String[]{"getHHMM", "getHHMMSS"};
    }
}

