/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.LocalizedDate;
import java.util.Date;
import java.util.TimeZone;
import junit.framework.TestCase;

public class LocalizedDateTest
extends TestCase {
    long now = System.currentTimeMillis();
    LocalizedDate ld;

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testLocalizedDateLong() {
        this.ld = new LocalizedDate(this.now);
        LocalizedDateTest.assertEquals((Object)LocalizedDate.LOCAL_TIMEZONE, (Object)this.ld.getTimeZone());
    }

    public void testLocalTimeZoneIsNeverNull() {
        LocalizedDate.LOCAL_TIMEZONE = null;
        LocalizedDateTest.assertNotNull((Object)LocalizedDate.getLocalTimeZone());
    }

    public void testLocalizedDateLongTimeZone() {
        TimeZone timeZone = TimeZone.getTimeZone("GMT+04");
        this.ld = new LocalizedDate(this.now, timeZone);
        LocalizedDateTest.assertEquals((Object)timeZone, (Object)this.ld.getTimeZone());
        this.ld = new LocalizedDate(this.now, null);
        LocalizedDateTest.assertEquals((Object)LocalizedDate.LOCAL_TIMEZONE, (Object)this.ld.getTimeZone());
    }

    public void testLocalizedDateDate() {
        Date date = new Date(this.now);
        this.ld = new LocalizedDate(date);
        LocalizedDateTest.assertEquals((Object)LocalizedDate.LOCAL_TIMEZONE, (Object)this.ld.getTimeZone());
    }

    public void testLocalizedDateDateTimeZone() {
        Date date = new Date(this.now);
        TimeZone timeZone = TimeZone.getTimeZone("GMT+04");
        this.ld = new LocalizedDate(date, timeZone);
        LocalizedDateTest.assertEquals((Object)timeZone, (Object)this.ld.getTimeZone());
    }

    public void testGetTimeZone() {
        this.ld = new LocalizedDate(this.now);
        LocalizedDateTest.assertEquals((Object)LocalizedDate.LOCAL_TIMEZONE, (Object)this.ld.getTimeZone());
    }

    public void testGetLocalTimeZone() {
        this.ld = new LocalizedDate(this.now);
        LocalizedDateTest.assertEquals((Object)TimeZone.getDefault(), (Object)LocalizedDate.getLocalTimeZone());
        TimeZone timeZone = TimeZone.getTimeZone("GMT+04");
        LocalizedDate.setLocalTimeZone(timeZone);
        LocalizedDateTest.assertEquals((Object)timeZone, (Object)LocalizedDate.getLocalTimeZone());
        LocalizedDate.setLocalTimeZone(null);
        LocalizedDateTest.assertEquals((Object)LocalizedDate.LOCAL_TIMEZONE, (Object)LocalizedDate.getLocalTimeZone());
    }

    public void testCorrectTime() {
        this.ld = new LocalizedDate(this.now);
        TimeZone timeZone = TimeZone.getDefault();
        long l = this.ld.getTime();
        int n = timeZone.getOffset(l);
        int n2 = LocalizedDate.LOCAL_TIMEZONE.getOffset(l);
        long l2 = l + (long)n - (long)n2;
        LocalizedDate.correctTime(this.ld);
        LocalizedDateTest.assertEquals((long)l2, (long)this.ld.getTime());
    }

    public void testToString() {
        this.ld = new LocalizedDate(this.now, TimeZone.getTimeZone("GMT+4"));
        String string = this.ld.toString();
        this.ld = new LocalizedDate(this.now, TimeZone.getTimeZone("GMT"));
        String string2 = this.ld.toString();
        LocalizedDateTest.assertTrue((boolean)string.endsWith("GMT+04:00"));
        LocalizedDateTest.assertTrue((boolean)string2.endsWith("GMT"));
    }
}

