/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.TimeZoneWrapper;
import com.helpsystems.common.core.util.DateTranslator;
import java.io.Serializable;
import java.util.Date;
import java.util.TimeZone;

public class LocalizedDate
extends java.sql.Date
implements Serializable,
TimeZoneWrapper {
    private static final long serialVersionUID = 5547594811645163333L;
    static TimeZone LOCAL_TIMEZONE = TimeZone.getDefault();
    private TimeZone originalTimezone;

    public LocalizedDate(long l) {
        this(l, LOCAL_TIMEZONE);
    }

    public LocalizedDate(long l, TimeZone timeZone) {
        super(l);
        this.originalTimezone = timeZone == null ? LOCAL_TIMEZONE : timeZone;
    }

    public LocalizedDate(Date date) {
        this(date.getTime(), LOCAL_TIMEZONE);
    }

    public LocalizedDate(Date date, TimeZone timeZone) {
        this(date.getTime(), timeZone);
    }

    @Override
    public TimeZone getTimeZone() {
        return this.originalTimezone;
    }

    public static void setLocalTimeZone(TimeZone timeZone) {
        LOCAL_TIMEZONE = timeZone == null ? TimeZone.getDefault() : timeZone;
    }

    public static TimeZone getLocalTimeZone() {
        if (LOCAL_TIMEZONE == null) {
            return TimeZone.getDefault();
        }
        return LOCAL_TIMEZONE;
    }

    public static void correctTime(Date date) {
        TimeZone timeZone = TimeZone.getDefault();
        TimeZone timeZone2 = LOCAL_TIMEZONE;
        if (date instanceof TimeZoneWrapper) {
            timeZone2 = ((TimeZoneWrapper)((Object)date)).getTimeZone();
        }
        long l = date.getTime();
        int n = timeZone.getOffset(l);
        int n2 = timeZone2.getOffset(l);
        long l2 = l + (long)n - (long)n2;
        date.setTime(l2);
    }

    @Override
    public String toString() {
        return LocalizedDate.toString(this, this.getTimeZone());
    }

    static String toString(Date date, TimeZone timeZone) {
        String string = DateTranslator.formatDateTime(date, timeZone);
        if (!LOCAL_TIMEZONE.equals(timeZone)) {
            string = string + " " + timeZone.getID();
        }
        return string;
    }
}

