/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.busobj.InstalledProduct;
import com.helpsystems.common.core.busobj.InstalledProducts;
import com.helpsystems.common.core.network.SystemIID;
import junit.framework.TestCase;

public class InstalledProductsTest
extends TestCase {
    InstalledProducts prods;
    BasicIdentifier id;

    protected void setUp() throws Exception {
        super.setUp();
        this.prods = InstalledProducts.getInstance();
        this.prods.clearProducts();
        this.id = new SystemIID(1234);
    }

    protected void tearDown() throws Exception {
        this.id = null;
        this.prods = null;
        super.tearDown();
    }

    public void testClearProducts() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        InstalledProduct installedProduct2 = new InstalledProduct("RBT", "R10M05", "ROBOTLIB");
        this.prods.add(installedProduct, this.id);
        this.prods.add(installedProduct2, this.id);
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled("CON", this.id));
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled("RBT", this.id));
        this.prods.clearProducts();
        InstalledProductsTest.assertFalse((boolean)this.prods.isProductInstalled("CON", this.id));
        InstalledProductsTest.assertFalse((boolean)this.prods.isProductInstalled("RBT", this.id));
    }

    public void testIsProductInstalledStringBasicIdentifier() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        InstalledProduct installedProduct2 = new InstalledProduct("RBT", "R10M05", "ROBOTLIB");
        this.prods.add(installedProduct, this.id);
        this.prods.add(installedProduct2, this.id);
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled("CON", this.id));
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled("RBT", this.id));
        InstalledProductsTest.assertFalse((boolean)this.prods.isProductInstalled("REP", this.id));
    }

    public void testIsProductInstalledIntBasicIdentifier() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        InstalledProduct installedProduct2 = new InstalledProduct("RBT", "R10M05", "ROBOTLIB");
        this.prods.add(installedProduct, this.id);
        this.prods.add(installedProduct2, this.id);
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled(3, this.id));
        InstalledProductsTest.assertTrue((boolean)this.prods.isProductInstalled(1, this.id));
        InstalledProductsTest.assertFalse((boolean)this.prods.isProductInstalled(20, this.id));
    }

    public void testGetInstalledProductReturnsNullIfNotInstalled() {
        InstalledProduct installedProduct = this.prods.getInstalledProduct("RBT", this.id);
        InstalledProductsTest.assertNull((Object)installedProduct);
    }

    public void testAdd() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        this.prods.add(installedProduct, this.id);
        InstalledProductsTest.assertEquals((Object)installedProduct, (Object)this.prods.getInstalledProduct("CON", this.id));
    }

    public void testGetInstalledProductsDeprecatedReturnsNull() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        InstalledProduct installedProduct2 = new InstalledProduct("RBT", "R10M05", "ROBOTLIB");
        this.prods.add(installedProduct, this.id);
        this.prods.add(installedProduct2, this.id);
        InstalledProduct[] installedProductArray = this.prods.getInstalledProducts();
        InstalledProductsTest.assertNull((Object)installedProductArray);
    }

    public void testLogListDeprecated() {
        InstalledProduct installedProduct = new InstalledProduct("CON", "R04M29", "RBTCONLIB");
        this.prods.add(installedProduct, this.id);
        this.prods.logList();
    }
}

