/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import java.util.ArrayList;
import java.util.Arrays;

public class Feedback
extends CommonVersionedObject {
    private static final long serialVersionUID = 7058768094216513336L;
    ArrayList<Throwable> errors;
    ArrayList<String> warnings;
    ArrayList<String> successes;

    public Throwable[] getErrors() {
        if (this.errors != null) {
            Throwable[] throwableArray = new Throwable[this.errors.size()];
            throwableArray = this.errors.toArray(throwableArray);
            return throwableArray;
        }
        return new Throwable[0];
    }

    public String[] getWarnings() {
        if (this.warnings != null) {
            String[] stringArray = new String[this.warnings.size()];
            stringArray = this.warnings.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public String[] getSuccesses() {
        if (this.successes != null) {
            String[] stringArray = new String[this.successes.size()];
            stringArray = this.successes.toArray(stringArray);
            return stringArray;
        }
        return new String[0];
    }

    public void addError(Throwable throwable) {
        if (this.errors == null) {
            this.errors = new ArrayList();
        }
        this.errors.add(throwable);
    }

    public void addErrors(Throwable[] throwableArray) {
        if (throwableArray != null) {
            if (this.errors == null) {
                this.errors = new ArrayList<Throwable>(Arrays.asList(throwableArray));
            } else {
                this.errors.addAll(Arrays.asList(throwableArray));
            }
        }
    }

    public void addWarning(String string) {
        if (this.warnings == null) {
            this.warnings = new ArrayList();
        }
        this.warnings.add(string);
    }

    public void addWarnings(String[] stringArray) {
        if (stringArray != null) {
            if (this.warnings == null) {
                this.warnings = new ArrayList<String>(Arrays.asList(stringArray));
            } else {
                this.warnings.addAll(Arrays.asList(stringArray));
            }
        }
    }

    public void addSuccess(String string) {
        if (this.successes == null) {
            this.successes = new ArrayList();
        }
        this.successes.add(string);
    }

    public void addSuccesses(String[] stringArray) {
        if (stringArray != null) {
            if (this.successes == null) {
                this.successes = new ArrayList<String>(Arrays.asList(stringArray));
            } else {
                this.successes.addAll(Arrays.asList(stringArray));
            }
        }
    }

    public boolean hasErrors() {
        return this.errors != null && this.errors.size() > 0;
    }

    public boolean hasWarnings() {
        return this.warnings != null && this.warnings.size() > 0;
    }

    public boolean hasSuccesses() {
        return this.successes != null && this.successes.size() > 0;
    }
}

