/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.DecimalNumber;
import java.math.BigDecimal;
import junit.framework.TestCase;

public class DecimalNumberTest
extends TestCase {
    DecimalNumber dn;

    protected void setUp() throws Exception {
        super.setUp();
        this.dn = new DecimalNumber(12345, 2);
    }

    protected void tearDown() throws Exception {
        this.dn = null;
        super.tearDown();
    }

    public void testGetUnscaledValue() {
        DecimalNumberTest.assertEquals((int)12345, (int)this.dn.getUnscaledValue());
    }

    public void testGetDecimalPlaces() {
        DecimalNumberTest.assertEquals((int)2, (int)this.dn.getDecimalPlaces());
    }

    public void testDecimalPlacesCannotBeLessThanZero() {
        try {
            new DecimalNumber(123, -2);
            DecimalNumberTest.fail((String)"DecimalNumber(int,int) allowed negative number of decimal places");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testToString() {
        DecimalNumberTest.assertEquals((String)"123.45", (String)this.dn.toString());
        DecimalNumberTest.assertEquals((String)"-123", (String)new DecimalNumber(-123, 0).toString());
        DecimalNumberTest.assertEquals((String)"0.02", (String)new DecimalNumber(2, 2).toString());
        DecimalNumberTest.assertEquals((String)"-123.4", (String)new DecimalNumber(-1234, 1).toString());
    }

    public void testToBigDecimal() {
        DecimalNumberTest.assertEquals((Object)new BigDecimal("123.45"), (Object)this.dn.toBigDecimal());
        DecimalNumberTest.assertEquals((Object)new BigDecimal("12345"), (Object)new DecimalNumber(12345, 0).toBigDecimal());
        DecimalNumberTest.assertEquals((Object)new BigDecimal("-123"), (Object)new DecimalNumber(-123, 0).toBigDecimal());
        DecimalNumberTest.assertEquals((Object)new BigDecimal("0.02"), (Object)new DecimalNumber(2, 2).toBigDecimal());
        DecimalNumberTest.assertEquals((Object)new BigDecimal("-123.4"), (Object)new DecimalNumber(-1234, 1).toBigDecimal());
    }
}

