/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.busobj;

import com.helpsystems.common.core.busobj.CommonVersionedObject;
import java.math.BigDecimal;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.util.Arrays;

public class DecimalNumber
extends CommonVersionedObject {
    private static final long serialVersionUID = -3669216706405061236L;
    private int unscaledValue;
    private int decimalPlaces;

    public DecimalNumber(int n, int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("Program eror: The number ofimplied decimal places must be >= zero.");
        }
        this.unscaledValue = n;
        this.decimalPlaces = n2;
    }

    public int getUnscaledValue() {
        return this.unscaledValue;
    }

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public String toString() {
        String string;
        Object object;
        boolean bl;
        if (this.decimalPlaces == 0) {
            return NumberFormat.getIntegerInstance().format(this.unscaledValue);
        }
        char c = new DecimalFormatSymbols().getDecimalSeparator();
        String string2 = Integer.toString(Math.abs(this.unscaledValue));
        boolean bl2 = bl = string2.length() > this.decimalPlaces;
        if (bl) {
            object = string2.substring(0, string2.length() - this.decimalPlaces);
            String string3 = string2.substring(string2.length() - this.decimalPlaces);
            int n = Integer.parseInt((String)object);
            String string4 = NumberFormat.getIntegerInstance().format(n);
            string = string4 + c + string3;
        } else {
            object = new char[this.decimalPlaces - string2.length()];
            Arrays.fill(object, '0');
            string = "0" + c + new String((char[])object) + string2;
        }
        if (this.unscaledValue < 0) {
            char c2 = new DecimalFormatSymbols().getMinusSign();
            string = c2 + string;
        }
        return string;
    }

    public BigDecimal toBigDecimal() {
        return new BigDecimal(this.toNonLocalizedString());
    }

    private String toNonLocalizedString() {
        String string;
        boolean bl;
        if (this.decimalPlaces == 0) {
            return Integer.toString(this.unscaledValue);
        }
        String string2 = Integer.toString(Math.abs(this.unscaledValue));
        boolean bl2 = bl = string2.length() > this.decimalPlaces;
        if (bl) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            int n = string2.length() - this.decimalPlaces;
            string = stringBuffer.insert(n, '.').toString();
        } else {
            char[] cArray = new char[this.decimalPlaces - string2.length()];
            Arrays.fill(cArray, '0');
            string = "0." + new String(cArray) + string2;
        }
        if (this.unscaledValue < 0) {
            string = "-" + string;
        }
        return string;
    }
}

