/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import com.helpsystems.common.core.access.dataset.DataSetList;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import org.apache.log4j.Logger;

public class TempFileDataSet<T>
implements DataSet<T> {
    private static final Logger logger = Logger.getLogger(TempFileDataSet.class);
    private static final int NULL_PLACEHOLDER = -100;
    private long[] offsetArray;
    private int[] sizeArray;
    private boolean isClosed;
    private File tempFile;
    private RandomAccessFile tempFilePointer;
    private EncryptUtil encryptUtil;
    private int size;
    private DataSetList realDS;

    public TempFileDataSet(DataSet<T> dataSet) throws DataSetException, BadDataException, IOException {
        this(dataSet, null);
    }

    public TempFileDataSet(DataSet<T> dataSet, EncryptUtil encryptUtil) throws DataSetException, BadDataException, IOException {
        ValidationHelper.checkForNull("DataSet", dataSet);
        this.size = dataSet.size();
        this.tempFile = File.createTempFile("filecache", ".ds");
        logger.trace((Object)("Using temp file " + this.tempFile.getAbsolutePath()));
        this.tempFile.delete();
        this.tempFile.deleteOnExit();
        this.tempFilePointer = new RandomAccessFile(this.tempFile, "rw");
        this.offsetArray = new long[this.size];
        this.sizeArray = new int[this.size];
        this.encryptUtil = encryptUtil;
        this.realDS = new DataSetList<T>(dataSet);
        this.cacheIndex(0);
        Thread thread = new Thread(new DataSetCopier());
        thread.setName("TFDS_Copier");
        thread.start();
    }

    private void cacheIndex(int n) throws DataSetException {
        BadDataException badDataException = null;
        try {
            badDataException = this.realDS.get(n);
        }
        catch (BadDataException badDataException2) {
            badDataException = badDataException2;
        }
        this.cacheObject(n, badDataException);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheObject(int n, Object object) throws DataSetException {
        if (object == null) {
            this.offsetArray[n] = -100L;
            return;
        }
        byte[] byArray = this.serialize(object);
        try {
            RandomAccessFile randomAccessFile = this.tempFilePointer;
            synchronized (randomAccessFile) {
                long l = this.tempFilePointer.length();
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Writing index: " + n + "\t offset: " + l + "\t size: " + byArray.length));
                }
                this.tempFilePointer.seek(l);
                this.tempFilePointer.write(byArray);
                this.offsetArray[n] = l;
                this.sizeArray[n] = byArray.length;
            }
        }
        catch (IOException iOException) {
            throw new DataSetException("Error when writing data to the temp file.", iOException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object decacheObject(int n) throws DataSetException {
        if (n >= this.size) {
            throw new IllegalArgumentException("Index " + n + " >= size " + this.size);
        }
        long l = this.offsetArray[n];
        if (l == -100L) {
            return null;
        }
        int n2 = this.sizeArray[n];
        if (n2 == 0) {
            this.cacheIndex(n);
            return this.decacheObject(n);
        }
        byte[] byArray = new byte[n2];
        try {
            RandomAccessFile randomAccessFile = this.tempFilePointer;
            synchronized (randomAccessFile) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("Reading index: " + n + "\t offset: " + l + "\t size: " + n2));
                }
                this.tempFilePointer.seek(l);
                this.tempFilePointer.read(byArray);
            }
        }
        catch (IOException iOException) {
            throw new DataSetException("Error when reading data from the temp file.", iOException);
        }
        return this.deserialize(byArray);
    }

    protected void checkIfClosed() throws DataSetClosedException {
        if (this.isClosed) {
            throw new DataSetClosedException("The DataSet is closed.");
        }
    }

    @Override
    public void close() throws DataSetException {
        if (!this.isClosed) {
            this.isClosed = true;
            this.offsetArray = null;
            this.sizeArray = null;
            this.closeRealDataSet();
            Exception exception = null;
            try {
                if (this.realDS != null) {
                    this.realDS.close();
                }
            }
            catch (DataSetException dataSetException) {
                exception = dataSetException;
            }
            try {
                this.tempFilePointer.close();
            }
            catch (IOException iOException) {
                exception = iOException;
            }
            this.tempFile.delete();
            if (exception != null) {
                throw new DataSetException("Unable to close the resources.", exception);
            }
        }
    }

    private void closeRealDataSet() {
        try {
            this.realDS.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        this.checkIfClosed();
        Object[] objectArray = new Object[n2];
        ErrorTable errorTable = null;
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = this.decacheObject(n + i);
            if (!(object instanceof BadDataException)) continue;
            BadDataException badDataException = (BadDataException)object;
            objectArray[i] = badDataException.getLoadedObject();
            if (errorTable == null) {
                errorTable = new ErrorTable();
            }
            ErrorList errorList = badDataException.getErrorList();
            errorTable.addExceptions(i, errorList);
        }
        if (errorTable != null) {
            throw new BadDataArrayException("One or more objects contains bad data.", objectArray, errorTable);
        }
        return objectArray;
    }

    @Override
    public int size() throws DataSetException {
        this.checkIfClosed();
        return this.size;
    }

    private Object deserialize(byte[] byArray) throws DataSetException {
        byte[] byArray2 = new byte[byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        try {
            if (this.encryptUtil != null) {
                byArray2 = this.encryptUtil.decodeBinary(byArray);
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Error when decrypting the temp data.", exception);
        }
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray2);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            Object object = objectInputStream.readObject();
            objectInputStream.close();
            byteArrayInputStream.close();
            return object;
        }
        catch (Exception exception) {
            throw new DataSetException("Error when deserializing the object data.", exception);
        }
    }

    private byte[] serialize(Object object) throws DataSetException {
        byte[] byArray = null;
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
            objectOutputStream.writeObject(object);
            objectOutputStream.close();
            byteArrayOutputStream.close();
            byArray = byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            throw new DataSetException("Unable to serialize the object " + object.getClass().getName(), iOException);
        }
        try {
            if (this.encryptUtil != null) {
                byArray = this.encryptUtil.encodeBinary(byArray);
            }
        }
        catch (Exception exception) {
            throw new DataSetException("Error when encrypting the temp data.", exception);
        }
        return byArray;
    }

    private class DataSetCopier
    implements Runnable {
        private DataSetCopier() {
        }

        @Override
        public void run() {
            try {
                if (!TempFileDataSet.this.isClosed) {
                    for (int i = 1; i < TempFileDataSet.this.size; ++i) {
                        if (TempFileDataSet.this.offsetArray[i] != 0L) continue;
                        try {
                            TempFileDataSet.this.cacheIndex(i);
                            continue;
                        }
                        catch (DataSetException dataSetException) {
                            logger.debug((Object)"Copier thread encountered an error", (Throwable)dataSetException);
                            TempFileDataSet.this.closeRealDataSet();
                            return;
                        }
                    }
                    TempFileDataSet.this.closeRealDataSet();
                    return;
                }
            }
            catch (Exception exception) {
                if (TempFileDataSet.this.isClosed) {
                    logger.trace((Object)"Data Set closed, Copier Thread exiting.");
                }
                logger.debug((Object)"Copier Thread exiting due to error.", (Throwable)exception);
            }
        }
    }
}

