/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import com.helpsystems.common.core.util.ValidationHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class SortedAggregateDataSet<T>
implements DataSet {
    private static final Logger logger = Logger.getLogger(SortedAggregateDataSet.class);
    protected ArrayList<DataSet<T>> dataSetList = new ArrayList();
    protected int aggregateSize;
    protected boolean isClosed;
    protected volatile int sortPoint;
    protected int[] sortedSource;
    protected int[] sortedIndex;
    protected Thread sorter;
    protected boolean keepSorting;
    protected Comparator comparator;

    public SortedAggregateDataSet(Comparator comparator) {
        this.comparator = comparator;
        this.clearSort();
    }

    protected void clearSort() {
        this.aggregateSize = 0;
        this.sortPoint = -1;
        this.sortedSource = null;
        this.sortedIndex = null;
        if (this.sorter != null && this.sorter.isAlive()) {
            this.sorter.interrupt();
        }
        this.sorter = null;
        this.keepSorting = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(DataSet<T> dataSet) throws DataSetException {
        ValidationHelper.checkForNull("DataSet", dataSet);
        this.checkIfClosed();
        if (this.sortPoint >= 0) {
            throw new IllegalStateException("Sorting has already commenced.  It's too late to add DataSets unless you close() first.");
        }
        if (dataSet.size() == 0) {
            return;
        }
        ArrayList<DataSet<T>> arrayList = this.dataSetList;
        synchronized (arrayList) {
            if (!(dataSet instanceof CachingDataSet)) {
                this.dataSetList.add(new CachingDataSet(dataSet));
            } else {
                this.dataSetList.add(dataSet);
            }
            this.aggregateSize += dataSet.size();
        }
    }

    @Override
    public void close() {
        Iterator<DataSet<T>> iterator = this.dataSetList.iterator();
        this.keepSorting = false;
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        while (iterator.hasNext()) {
            DataSet<T> dataSet = iterator.next();
            try {
                dataSet.close();
            }
            catch (DataSetException dataSetException) {
                logger.debug((Object)"Unable to close a DataSet", (Throwable)dataSetException);
            }
        }
        this.sortPoint = -1;
    }

    protected void checkIfClosed() throws DataSetClosedException {
        if (this.isClosed) {
            throw new DataSetClosedException("This DataSet is Closed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        Object[] objectArray = null;
        this.checkIfClosed();
        if (this.dataSetList.size() < 2) {
            if (this.dataSetList.size() == 0) {
                return null;
            }
            DataSet<T> dataSet = this.dataSetList.get(0);
            return dataSet.get(n, n2);
        }
        if (n < 0 || n >= this.aggregateSize) {
            throw new IndexOutOfBoundsException("Invalid offset: " + n);
        }
        if (n + n2 > this.aggregateSize) {
            throw new IndexOutOfBoundsException("Offset: " + n + " + Length: " + n2 + " > Size: " + this.aggregateSize);
        }
        if (this.sortPoint < 0) {
            this.startSort();
        }
        while (n + n2 > this.sortPoint) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (this.keepSorting && !this.isClosed) continue;
            throw new DataSetClosedException("DataSet has been closed.");
        }
        ArrayList<DataSet<T>> arrayList = this.dataSetList;
        synchronized (arrayList) {
            objectArray = new Object[n2];
            for (int i = 0; i < n2; ++i) {
                DataSet<T> dataSet = this.dataSetList.get(this.sortedSource[i + n]);
                objectArray[i] = dataSet.get(this.sortedIndex[i + n], 1)[0];
            }
        }
        return objectArray;
    }

    protected void sortOfSlow() throws DataSetException, BadDataArrayException {
        int n = this.dataSetList.size();
        int[] nArray = new int[n];
        int[] nArray2 = new int[n];
        boolean[] blArray = new boolean[n];
        this.checkIfClosed();
        for (int i = 0; i < n; ++i) {
            blArray[i] = false;
            nArray[i] = 0;
            nArray2[i] = this.dataSetList.get(i).size();
        }
        DataSet<T> dataSet = this.dataSetList.get(0);
        int n2 = 0;
        DataSet<T> dataSet2 = null;
        logger.trace((Object)"Beginning merge-sort");
        this.sortedIndex = new int[this.aggregateSize];
        this.sortedSource = new int[this.aggregateSize];
        while (this.sortPoint < this.aggregateSize && this.keepSorting && !this.isClosed) {
            for (int i = 0; i < n; ++i) {
                if (dataSet == null) {
                    if (blArray[i]) continue;
                    dataSet = this.dataSetList.get(i);
                    n2 = i;
                    continue;
                }
                if (blArray[i] || i == n2 || this.comparator.compare((dataSet2 = this.dataSetList.get(i)).get(nArray[i], 1)[0], dataSet.get(nArray[n2], 1)[0]) >= 0) continue;
                dataSet = dataSet2;
                n2 = i;
            }
            if (this.sortPoint >= 0) {
                this.sortedSource[this.sortPoint] = n2;
                this.sortedIndex[this.sortPoint] = nArray[n2];
            } else if (this.keepSorting) {
                logger.debug((Object)("Sort point " + this.sortPoint + " is not valid."));
            }
            int n3 = n2;
            nArray[n3] = nArray[n3] + 1;
            if (nArray[n2] == nArray2[n2]) {
                blArray[n2] = true;
                dataSet = null;
            }
            ++this.sortPoint;
        }
        logger.trace((Object)"  sort done!");
    }

    public void startSort() {
        if (this.dataSetList.size() < 2) {
            this.sortPoint = this.aggregateSize;
            return;
        }
        if (this.sortPoint < 0) {
            this.sortPoint = 0;
            this.sorter = new Thread(){

                @Override
                public void run() {
                    this.setName("SortedAggregateDataSet sort Thread");
                    try {
                        SortedAggregateDataSet.this.keepSorting = true;
                        SortedAggregateDataSet.this.sortOfSlow();
                    }
                    catch (Exception exception) {
                        logger.debug((Object)"Error while doing sort", (Throwable)exception);
                        SortedAggregateDataSet.this.close();
                    }
                }
            };
            this.sorter.start();
        }
    }

    @Override
    public int size() throws DataSetException {
        return this.aggregateSize;
    }
}

