/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.dataset.ArrayDataSet;
import com.helpsystems.common.core.access.dataset.SortedAggregateDataSet;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Random;

public class SADataSetTest {
    static Random random = new Random(System.currentTimeMillis());
    static int dataSetCount = 100;
    static int basicDataSetSize = 1000;

    private static DataSet createSortedDataSet(int n) {
        Object[] objectArray = new Integer[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = new Integer(random.nextInt(10000));
        }
        Arrays.sort(objectArray);
        return new ArrayDataSet<Object>(objectArray);
    }

    public static void main(String[] stringArray) {
        int n;
        long l = 0L;
        long l2 = 0L;
        SortedAggregateDataSet sortedAggregateDataSet = null;
        T[] TArray = null;
        int n2 = 0;
        sortedAggregateDataSet = new SortedAggregateDataSet(new IntegerComparator());
        for (int i = 0; i < dataSetCount; ++i) {
            n = basicDataSetSize + random.nextInt(5);
            DataSet dataSet = SADataSetTest.createSortedDataSet(n);
            try {
                sortedAggregateDataSet.add(dataSet);
            }
            catch (DataSetException dataSetException) {
                System.out.println("Life is over.");
                dataSetException.printStackTrace();
                System.exit(1);
            }
            n2 += n;
        }
        try {
            System.out.println("\nCreated " + dataSetCount + " DataSets, each containing " + basicDataSetSize + " or more elements.");
            System.out.println("Sum of all DataSet sizes is: " + n2);
            System.out.println("AggregateDataSet contains " + sortedAggregateDataSet.size() + " elements.");
            if (n2 != sortedAggregateDataSet.size()) {
                System.out.println("\nSize mismatch. LIFE IS OVER.");
                System.exit(1);
            }
            l = System.currentTimeMillis();
            System.out.println("starting sort");
            sortedAggregateDataSet.startSort();
            System.out.println("sort should be humming along... waiting for results.");
            TArray = sortedAggregateDataSet.get(0, sortedAggregateDataSet.size() / 10);
            System.out.println("10% sorted and returned in " + (System.currentTimeMillis() - l) + " ms");
            TArray = sortedAggregateDataSet.get(0, sortedAggregateDataSet.size() / 2);
            System.out.println("50% sorted and returned in " + (System.currentTimeMillis() - l) + " ms");
            TArray = sortedAggregateDataSet.get(0, sortedAggregateDataSet.size());
            l2 = System.currentTimeMillis();
            if (TArray.length != sortedAggregateDataSet.size()) {
                System.out.println("\nI didn't get all my numbers back. LIFE IS OVER!");
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.out.println("Life is over.");
            exception.printStackTrace();
            System.exit(1);
        }
        int n3 = 0;
        for (n = 0; n < TArray.length; ++n) {
            int n4 = (Integer)TArray[n];
            if (n4 < n3) {
                System.out.println("At " + n + ", " + n4 + " !< " + n3);
                System.out.println("ERROR! Numbers out of order.  Life is over.");
                System.exit(1);
            }
            n3 = n4;
        }
        System.out.println("\nTest complete.  Numbers merge-sorted successfully in " + (l2 - l) + "ms!");
    }

    private static class IntegerComparator
    implements Comparator {
        private IntegerComparator() {
        }

        public int compare(Object object, Object object2) {
            return ((Integer)object).compareTo((Integer)object2);
        }

        @Override
        public boolean equals(Object object) {
            return false;
        }
    }
}

