/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.CachingDataSet;
import com.helpsystems.common.core.access.dataset.ReloadException;
import com.helpsystems.common.core.access.dataset.ReloadableDataSet;
import com.helpsystems.common.core.access.dataset.SortedAggregateDataSet;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;

public class ReloadableSortedAggregateDataSet<T>
extends SortedAggregateDataSet<T>
implements ReloadableDataSet {
    private static final String WAITING = "W";
    private boolean doingReload;
    private Object waitingRoom;
    private ArrayList<Exception> reloadFailures = new ArrayList();

    public ReloadableSortedAggregateDataSet(Comparator comparator) {
        super(comparator);
        this.waitingRoom = new Object();
    }

    @Override
    public void add(ReloadableDataSet<T> reloadableDataSet) throws DataSetException {
        super.add(reloadableDataSet);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public int reload() throws DataSetException, ResourceUnavailableException {
        Object[] objectArray;
        Object[] objectArray2 = this.waitingRoom;
        // MONITORENTER : this.waitingRoom
        this.doingReload = true;
        // MONITOREXIT : objectArray2
        this.clearSort();
        this.reloadFailures.clear();
        objectArray2 = new Object[this.dataSetList.size()];
        for (int i = 0; i < objectArray2.length; ++i) {
            objectArray2[i] = WAITING;
        }
        Iterator iterator = this.dataSetList.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            CachingDataSet cachingDataSet = (CachingDataSet)iterator.next();
            cachingDataSet.initialize(0);
            objectArray = (Object[])cachingDataSet.getWrappedDataSet();
            this.reloadDataSet((ReloadableDataSet)objectArray, objectArray2, n);
            ++n;
        }
        int n2 = 0;
        n = 0;
        while (true) {
            Object object;
            if (n < objectArray2.length) {
                objectArray = objectArray2;
                // MONITORENTER : objectArray2
            } else {
                int n3;
                try {
                    if (this.reloadFailures.size() > 0) {
                        throw new ReloadException("Unable to reload the nested data set", this.reloadFailures.get(0));
                    }
                    this.startSort();
                    n3 = this.aggregateSize = n2;
                    object = this.waitingRoom;
                }
                catch (Throwable throwable) {
                    Object object2 = this.waitingRoom;
                    // MONITORENTER : object2
                    this.doingReload = false;
                    this.waitingRoom.notifyAll();
                    // MONITOREXIT : object2
                    throw throwable;
                }
                this.doingReload = false;
                this.waitingRoom.notifyAll();
                // MONITOREXIT : object
                return n3;
            }
            while (objectArray2[n] == WAITING) {
                try {
                    objectArray2.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new DataSetException("Interrupted during reload.");
                }
            }
            if (objectArray2[n] instanceof Integer) {
                object = (Integer)objectArray2[n];
                int n4 = (Integer)object;
                n2 += n4;
                ((CachingDataSet)this.dataSetList.get(n)).initialize(n4);
            }
            // MONITOREXIT : objectArray
            ++n;
        }
    }

    @Override
    public T[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        this.waitIfReloading();
        return super.get(n, n2);
    }

    @Override
    public int size() throws DataSetException {
        this.waitIfReloading();
        return super.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfReloading() throws DataSetException {
        Object object = this.waitingRoom;
        synchronized (object) {
            if (this.doingReload) {
                try {
                    this.waitingRoom.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new DataSetException("Interrupted while waiting for a data set reload.");
                }
            }
        }
    }

    private void reloadDataSet(ReloadableDataSet reloadableDataSet, Object[] objectArray, int n) {
        ReloadRunner reloadRunner = new ReloadRunner(reloadableDataSet, objectArray, n);
        Thread thread = new Thread(reloadRunner);
        thread.setName("Waiting for a Data Set reload");
        thread.setPriority(1);
        thread.start();
    }

    class ReloadRunner
    implements Runnable {
        ReloadableDataSet rds;
        Object[] reloadResults;
        int myindex;

        ReloadRunner(ReloadableDataSet reloadableDataSet, Object[] objectArray, int n) {
            this.rds = reloadableDataSet;
            this.reloadResults = objectArray;
            this.myindex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int n = 0;
            try {
                n = this.rds.reload();
            }
            catch (Exception exception) {
                ReloadableSortedAggregateDataSet.this.reloadFailures.add(exception);
            }
            Object[] objectArray = this.reloadResults;
            synchronized (this.reloadResults) {
                this.reloadResults[this.myindex] = new Integer(n);
                this.reloadResults.notify();
                // ** MonitorExit[var2_3] (shouldn't be in output)
                return;
            }
        }
    }
}

