/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access.dataset;

import com.helpsystems.common.core.access.DataSet;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.DataSetProducer;
import com.helpsystems.common.core.access.dataset.NotifyingDSPEvent;
import com.helpsystems.common.core.access.dataset.NotifyingDSPListener;
import com.helpsystems.common.core.busobj.UserIdentity;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.SortField;
import java.util.Enumeration;
import java.util.Vector;

public class NotifyingDataSetProducer<T>
implements DataSetProducer<T> {
    private Vector<NotifyingDSPListener> listenerList = null;
    private Vector<NotifyingDSPListener> ignoreList = null;
    protected DataSetProducer<T> realDSP = null;
    protected DataSet<T> lastLoadedDataSet = null;
    protected SortField lastSortField = null;
    private String dataSetName = null;

    public NotifyingDataSetProducer(DataSetProducer dataSetProducer) {
        this(dataSetProducer, null);
    }

    public NotifyingDataSetProducer(DataSetProducer dataSetProducer, String string) {
        this.dataSetName = string;
        this.realDSP = dataSetProducer;
        this.listenerList = new Vector(2);
        this.ignoreList = new Vector(1);
    }

    public void addListener(NotifyingDSPListener notifyingDSPListener) {
        this.listenerList.add(0, notifyingDSPListener);
    }

    public void ignoreNextEvent(NotifyingDSPListener notifyingDSPListener) {
        this.ignoreList.add(notifyingDSPListener);
    }

    public void removeListener(NotifyingDSPListener notifyingDSPListener) {
        this.listenerList.remove(notifyingDSPListener);
    }

    @Override
    public DataSet<T> getDataSet(UserIdentity userIdentity, DataFilter dataFilter, SortField sortField) throws DataSetException, ResourceUnavailableException {
        try {
            this.lastLoadedDataSet = this.realDSP.getDataSet(userIdentity, dataFilter, sortField);
            this.lastSortField = sortField;
            this.fireNewDataSetAvailable(new NotifyingDSPEvent(this, this.lastLoadedDataSet, sortField, 1));
        }
        catch (Exception exception) {
            String string = this.dataSetName;
            if (string == null) {
                string = "Unknown";
            }
            this.fireNewDataSetAvailable(new NotifyingDSPEvent(this, this.lastLoadedDataSet, sortField, -1, exception, this.dataSetName));
        }
        return this.lastLoadedDataSet;
    }

    protected void fireNewDataSetAvailable(NotifyingDSPEvent notifyingDSPEvent) {
        Enumeration<NotifyingDSPListener> enumeration = this.listenerList.elements();
        while (enumeration.hasMoreElements()) {
            NotifyingDSPListener notifyingDSPListener = enumeration.nextElement();
            if (this.ignoreList.contains(notifyingDSPListener)) {
                this.ignoreList.remove(notifyingDSPListener);
                continue;
            }
            if (notifyingDSPEvent.isConsumed()) continue;
            notifyingDSPListener.newDataSetAvailable(notifyingDSPEvent);
        }
    }
}

