/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerNotUniqueException;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.util.RelMod;
import java.util.Collection;
import junit.framework.TestCase;

public class ManagerRegistryTest
extends TestCase {
    IAbstractManager one;
    IAbstractManager two;
    IAbstractManager oneA;
    IAbstractManager three;
    ManagerRegistryPlugin plugin;

    protected void setUp() throws Exception {
        super.setUp();
        this.one = new ManagerOne();
        this.two = new ManagerTwo();
        this.oneA = new ManagerOne();
        this.three = new ManagerThree();
        this.plugin = new ManagerRegistryPlugin(){

            @Override
            public IAbstractManager lookupManager(BasicIdentifier basicIdentifier, String string, ClassLoader classLoader) throws ManagerNotFoundException {
                return null;
            }

            @Override
            public void reset() {
            }
        };
        ManagerRegistry.registerManager(this.one);
        ManagerRegistry.registerManager(this.two);
    }

    protected void tearDown() throws Exception {
        this.one = null;
        this.two = null;
        super.tearDown();
    }

    public void testGetManagerOrFailString() {
        IAbstractManager iAbstractManager = ManagerRegistry.getManagerOrFail("one");
        ManagerRegistryTest.assertEquals((Object)this.one, (Object)iAbstractManager);
        try {
            iAbstractManager = ManagerRegistry.getManagerOrFail("bogus");
            ManagerRegistryTest.fail((String)"getManagerOrFail() should have thrown ManagerNotFoundException");
        }
        catch (ManagerNotFoundException managerNotFoundException) {
            // empty catch block
        }
    }

    public void testGetManagers() {
        Collection<IAbstractManager> collection = ManagerRegistry.getManagers();
        ManagerRegistryTest.assertEquals((int)2, (int)collection.size());
    }

    public void testRemoveManager() {
        ManagerRegistry.removeManager("one");
        Collection<IAbstractManager> collection = ManagerRegistry.getManagers();
        ManagerRegistryTest.assertEquals((int)1, (int)collection.size());
        ManagerRegistryTest.assertTrue((boolean)((ManagerOne)this.one).isRemoved());
        ManagerRegistryTest.assertFalse((boolean)((ManagerTwo)this.two).isRemoved());
    }

    public void testReregisterManagerRemovesOldOne() {
        ManagerRegistry.registerManager(this.oneA);
        ManagerRegistryTest.assertTrue((boolean)((ManagerOne)this.one).isRemoved());
        ManagerRegistryTest.assertFalse((boolean)((ManagerOne)this.oneA).isRemoved());
        IAbstractManager iAbstractManager = ManagerRegistry.getManagerOrFail("one");
        ManagerRegistryTest.assertEquals((Object)this.oneA, (Object)iAbstractManager);
    }

    public void testRegisterNullManagerFailsGracefully() {
        try {
            ManagerRegistry.registerManager(null);
            ManagerRegistryTest.fail((String)"registerManager should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveAllWithNullPrefix() {
        try {
            ManagerRegistry.removeAll(null);
            ManagerRegistryTest.fail((String)"removeAll should have thrown NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testRemoveAllWithPrefix() {
        ManagerRegistry.removeAll("");
        ManagerRegistryTest.assertTrue((boolean)((ManagerOne)this.one).isRemoved());
        ManagerRegistryTest.assertTrue((boolean)((ManagerTwo)this.two).isRemoved());
    }

    public void testSetPlugin() {
        ManagerRegistryTest.assertNull((Object)ManagerRegistry.getPlugin());
        ManagerRegistry.setPlugin(this.plugin);
        ManagerRegistryTest.assertEquals((Object)this.plugin, (Object)ManagerRegistry.getPlugin());
        ManagerRegistry.setPlugin(null);
        ManagerRegistryTest.assertNull((Object)ManagerRegistry.getPlugin());
    }

    public void testGetManagerStartsWithExactMatch() {
        IAbstractManager iAbstractManager = ManagerRegistry.getManagerStartsWith("one");
        ManagerRegistryTest.assertEquals((Object)this.one, (Object)iAbstractManager);
    }

    public void testGetManagerStartsWithFoundOne() {
        IAbstractManager iAbstractManager = ManagerRegistry.getManagerStartsWith("two");
        ManagerRegistryTest.assertEquals((Object)this.two, (Object)iAbstractManager);
        iAbstractManager = ManagerRegistry.getManagerStartsWith("two.");
        ManagerRegistryTest.assertEquals((Object)this.two, (Object)iAbstractManager);
    }

    public void testGetManagerStartsWithFoundNone() {
        try {
            ManagerRegistry.getManagerStartsWith("bogus");
            ManagerRegistryTest.fail((String)"getManagerStartsWith() should have thrown ManagerNotFoundException");
        }
        catch (ManagerNotFoundException managerNotFoundException) {
            // empty catch block
        }
    }

    public void testGetManagerStartsWithFoundMoreThanOne() {
        ManagerRegistry.registerManager(this.three);
        try {
            ManagerRegistry.getManagerStartsWith("two");
            ManagerRegistryTest.fail((String)"getManagerStartsWith() should have thrown ManagerNotUniqueException");
        }
        catch (ManagerNotUniqueException managerNotUniqueException) {
            // empty catch block
        }
    }

    class ManagerThree
    implements IAbstractManager {
        private String name = "two.other";
        private boolean isRemoved;
        private RelMod iFaceVersion = new RelMod(10, 20);
        private RelMod mgrVersion = new RelMod(10, 35);

        ManagerThree() {
        }

        @Override
        public RelMod getInterfaceVersion() {
            return this.iFaceVersion;
        }

        @Override
        public RelMod getManagerVersion() {
            return this.mgrVersion;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void managerRemoved() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }
    }

    class ManagerTwo
    implements IAbstractManager {
        private String name = "two.main";
        private boolean isRemoved;
        private RelMod iFaceVersion = new RelMod(10, 20);
        private RelMod mgrVersion = new RelMod(10, 35);

        ManagerTwo() {
        }

        @Override
        public RelMod getInterfaceVersion() {
            return this.iFaceVersion;
        }

        @Override
        public RelMod getManagerVersion() {
            return this.mgrVersion;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void managerRemoved() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }
    }

    class ManagerOne
    implements IAbstractManager {
        private String name = "one";
        private boolean isRemoved;
        private RelMod iFaceVersion = new RelMod(10, 20);
        private RelMod mgrVersion = new RelMod(10, 35);

        ManagerOne() {
        }

        @Override
        public RelMod getInterfaceVersion() {
            return this.iFaceVersion;
        }

        @Override
        public RelMod getManagerVersion() {
            return this.mgrVersion;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public void managerRemoved() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }
    }
}

