/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.access.ManagerNotFoundException;
import com.helpsystems.common.core.access.ManagerNotUniqueException;
import com.helpsystems.common.core.access.ManagerPlugInException;
import com.helpsystems.common.core.access.ManagerRegistryPlugin;
import com.helpsystems.common.core.busobj.BasicIdentifier;
import com.helpsystems.common.core.network.ProductIID;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ManagerRegistry {
    private Hashtable<String, IAbstractManager> managerTable;
    private static ManagerRegistryPlugin plugin;
    private static ManagerRegistry theInstance;

    private ManagerRegistry() {
        theInstance = this;
        this.managerTable = new Hashtable();
    }

    private static ManagerRegistry getInstance() {
        if (theInstance == null) {
            new ManagerRegistry();
        }
        return theInstance;
    }

    public static IAbstractManager getManagerStartsWith(BasicIdentifier basicIdentifier, String string) {
        return ManagerRegistry.getManagerStartsWith(basicIdentifier, string, null);
    }

    public static IAbstractManager getManagerStartsWith(BasicIdentifier basicIdentifier, String string, ClassLoader classLoader) {
        if (basicIdentifier == null) {
            return ManagerRegistry.getManagerStartsWith(string);
        }
        if (basicIdentifier instanceof ProductIID && ((ProductIID)basicIdentifier).getID() == 0) {
            return ManagerRegistry.getManagerStartsWith(string);
        }
        if (plugin == null) {
            throw new ManagerPlugInException("There is no plug-in available to search for the data manager " + basicIdentifier + ":" + string);
        }
        return plugin.lookupManager(basicIdentifier, string, classLoader);
    }

    public static IAbstractManager getManager(String string) {
        return ManagerRegistry.getInstance().internalGetManager(string);
    }

    public static IAbstractManager getManager(String string, String string2) {
        String string3 = string;
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "." + string2;
        }
        return ManagerRegistry.getManager(string3);
    }

    public static IAbstractManager getManagerOrFail(String string) {
        IAbstractManager iAbstractManager = ManagerRegistry.getManager(string);
        if (iAbstractManager == null) {
            throw new ManagerNotFoundException(string);
        }
        return iAbstractManager;
    }

    public static IAbstractManager getManagerOrFail(String string, String string2) {
        String string3 = string;
        if (string2 != null && string2.length() > 0) {
            string3 = string3 + "." + string2;
        }
        return ManagerRegistry.getManagerOrFail(string3);
    }

    public static IAbstractManager getManagerStartsWith(String string) {
        IAbstractManager iAbstractManager = null;
        iAbstractManager = ManagerRegistry.getManager(string);
        if (iAbstractManager != null) {
            return iAbstractManager;
        }
        String string2 = !string.endsWith(".") ? string + "." : string;
        Iterator<IAbstractManager> iterator = ManagerRegistry.getManagers().iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IAbstractManager iAbstractManager2 = iterator.next();
            if (!iAbstractManager2.getName().startsWith(string2)) continue;
            iAbstractManager = iAbstractManager2;
            ++n;
        }
        if (n == 0) {
            throw new ManagerNotFoundException(string2);
        }
        if (n < 2) {
            return iAbstractManager;
        }
        throw new ManagerNotUniqueException(string2);
    }

    private IAbstractManager internalGetManager(String string) {
        return this.managerTable.get(string);
    }

    public static void registerManager(IAbstractManager iAbstractManager) {
        ManagerRegistry.getInstance().internalRegisterManager(iAbstractManager);
    }

    private void internalRegisterManager(IAbstractManager iAbstractManager) {
        if (iAbstractManager == null) {
            throw new NullPointerException("The manager passed in was null.");
        }
        IAbstractManager iAbstractManager2 = this.managerTable.put(iAbstractManager.getName(), iAbstractManager);
        if (iAbstractManager2 != null) {
            iAbstractManager2.managerRemoved();
        }
    }

    public static Collection<IAbstractManager> getManagers() {
        return ManagerRegistry.getInstance().internalGetManagers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<IAbstractManager> internalGetManagers() {
        Hashtable<String, IAbstractManager> hashtable = this.managerTable;
        synchronized (hashtable) {
            return Collections.unmodifiableCollection(this.managerTable.values());
        }
    }

    public static IAbstractManager removeManager(String string) {
        return ManagerRegistry.getInstance().internalRemoveManager(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IAbstractManager internalRemoveManager(String string) {
        IAbstractManager iAbstractManager = null;
        Hashtable<String, IAbstractManager> hashtable = this.managerTable;
        synchronized (hashtable) {
            iAbstractManager = this.managerTable.remove(string);
        }
        if (iAbstractManager != null) {
            iAbstractManager.managerRemoved();
        }
        return iAbstractManager;
    }

    public void removeAll() {
        ManagerRegistry.removeAll("");
    }

    public static void removeAll(String string) {
        ManagerRegistry.getInstance().internalRemoveAll(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalRemoveAll(String string) {
        if (string == null) {
            throw new NullPointerException("Prefix cannot be null.");
        }
        Hashtable<String, IAbstractManager> hashtable = this.managerTable;
        synchronized (hashtable) {
            Enumeration<String> enumeration = this.managerTable.keys();
            while (enumeration.hasMoreElements()) {
                String string2 = enumeration.nextElement();
                if (!string2.startsWith(string)) continue;
                this.internalRemoveManager(string2);
            }
        }
    }

    public static void setPlugin(ManagerRegistryPlugin managerRegistryPlugin) {
        plugin = managerRegistryPlugin;
    }

    public static ManagerRegistryPlugin getPlugin() {
        return plugin;
    }
}

