/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.GenericManagerLoader;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.util.RelMod;
import junit.framework.TestCase;

public class GenericManagerLoaderTest
extends TestCase {
    GenericManagerLoader gml;

    protected void setUp() throws Exception {
        super.setUp();
        this.gml = new MyGML("libraryName", "suffix");
    }

    protected void tearDown() throws Exception {
        this.gml = null;
        super.tearDown();
    }

    public void testConstructorRequiresNonNullLibrary() {
        try {
            new MyGML(null, "suffix");
            GenericManagerLoaderTest.fail((String)"Constructor should require non-null library");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorRequiresNonBlankLibrary() {
        try {
            new MyGML("", "suffix");
            GenericManagerLoaderTest.fail((String)"Constructor should require non-empty library");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            new MyGML("  ", "suffix");
            GenericManagerLoaderTest.fail((String)"Constructor should require non-blank library");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testGetInterfaceVersion() {
        ManagerOne managerOne = new ManagerOne();
        managerOne.setName("one");
        this.gml.registerManager(managerOne);
        RelMod relMod = this.gml.getInterfaceVersion();
        GenericManagerLoaderTest.assertEquals((Object)new RelMod(5, 5), (Object)relMod);
    }

    public void testSetAdditionalManagerAttributes() {
        GenericManagerLoaderTest.assertFalse((boolean)((MyGML)this.gml).isAttrSet());
        ManagerOne managerOne = new ManagerOne();
        managerOne.setName("one");
        this.gml.registerManager(managerOne);
        GenericManagerLoaderTest.assertTrue((boolean)((MyGML)this.gml).isAttrSet());
    }

    public void testGetLibrary() {
        GenericManagerLoaderTest.assertEquals((String)"libraryName", (String)this.gml.getLibrary());
    }

    public void testGetSuffix() {
        GenericManagerLoaderTest.assertEquals((String)"suffix", (String)this.gml.getSuffix());
    }

    public void testIsProductMasterMode() {
        this.gml = new MyGML("libraryName", "_PM");
        GenericManagerLoaderTest.assertTrue((boolean)this.gml.isProductMasterMode());
        this.gml = new MyGML("libraryName", "_DR");
        GenericManagerLoaderTest.assertFalse((boolean)this.gml.isProductMasterMode());
    }

    public void testIsDataReplicationMode() {
        this.gml = new MyGML("libraryName", "_PM");
        GenericManagerLoaderTest.assertFalse((boolean)this.gml.isDataReplicationMode());
        this.gml = new MyGML("libraryName", "_DR");
        GenericManagerLoaderTest.assertTrue((boolean)this.gml.isDataReplicationMode());
    }

    class ManagerOne
    extends AbstractManager {
        private boolean isRemoved;
        private RelMod iFaceVersion = new RelMod(10, 20);
        private RelMod mgrVersion = new RelMod(10, 35);

        ManagerOne() {
        }

        @Override
        public RelMod getInterfaceVersion() {
            return this.iFaceVersion;
        }

        @Override
        public RelMod getManagerVersion() {
            return this.mgrVersion;
        }

        @Override
        public void managerRemoved() {
            this.isRemoved = true;
        }

        public boolean isRemoved() {
            return this.isRemoved;
        }
    }

    class MyGML
    extends GenericManagerLoader {
        private boolean attrSet;

        protected MyGML(String string, String string2) {
            super(string, string2);
        }

        @Override
        protected RelMod retrieveInterfaceVersion() throws ResourceUnavailableException {
            return new RelMod(5, 5);
        }

        @Override
        protected void setAdditionalManagerAttributes(AbstractManager abstractManager) {
            super.setAdditionalManagerAttributes(abstractManager);
            this.attrSet = true;
        }

        @Override
        public void loadAll() throws ResourceUnavailableException {
        }

        public boolean isAttrSet() {
            return this.attrSet;
        }
    }
}

