/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.busobj.CommonVersionedObject;
import java.util.ArrayList;

public class ExceptionErrorList
extends CommonVersionedObject
implements ErrorList {
    private static final long serialVersionUID = -6327854781365593606L;
    private static final int RESET_POSITION = -1;
    int position = -1;
    ArrayList<Exception> exceptions = new ArrayList(0);

    @Override
    public int getErrorCount() {
        return this.exceptions.size();
    }

    @Override
    public void resetErrorPosition() {
        this.position = -1;
    }

    @Override
    public boolean nextError() {
        if (this.position + 1 >= this.exceptions.size()) {
            return false;
        }
        ++this.position;
        return true;
    }

    @Override
    public String getErrorText() {
        Exception exception = (Exception)this.getErrorObject();
        return exception.getMessage();
    }

    @Override
    public Object getErrorObject() {
        if (this.exceptions.size() == 0) {
            throw new RuntimeException("There are no errors to report!");
        }
        if (this.position < 0) {
            throw new RuntimeException("Error position is not set.  Use nextError() or resetErrorPosition().");
        }
        return this.exceptions.get(this.position);
    }

    @Override
    public String getOptionPaneMessage() {
        if (this.exceptions.size() == 0) {
            return "There are no errors.";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.exceptions.size(); ++i) {
            Exception exception = this.exceptions.get(i);
            if (i > 0) {
                stringBuffer.append("\n");
            }
            stringBuffer.append(exception.getMessage());
        }
        return stringBuffer.toString();
    }

    public Exception[] getExceptions() {
        Exception[] exceptionArray = new Exception[this.exceptions.size()];
        this.exceptions.toArray(exceptionArray);
        return exceptionArray;
    }

    public void addException(Exception exception) {
        this.exceptions.add(exception);
    }
}

