/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.BadDataException;
import com.helpsystems.common.core.access.ErrorList;
import com.helpsystems.common.core.access.ErrorTable;
import junit.framework.TestCase;

public class BadDataArrayExceptionTest
extends TestCase {
    private BadDataArrayException bdae;
    private Object[] obj;
    private ErrorTable et;

    protected void setUp() throws Exception {
        super.setUp();
        this.obj = new Object[3];
        this.obj[0] = new Object();
        this.obj[1] = new Object();
        this.obj[2] = new Object();
        this.et = new ErrorTable();
        this.et.addException(0, new Exception("exception at index 0"));
        this.et.addException(1, new BadDataException("exception at index 1", this.obj[1], null));
        this.et.addException(3, new Exception("exception at index 3"));
        this.et.addException(3, new Exception("another exception at index 3"));
        this.bdae = new BadDataArrayException("", this.obj, this.et);
    }

    protected void tearDown() throws Exception {
        this.bdae = null;
        this.obj = null;
        this.et = null;
        super.tearDown();
    }

    public void testConstructorRequiresAnArrayOfObjects() {
        try {
            new BadDataArrayException("aBadDataArrayException", null, this.et);
            BadDataArrayExceptionTest.fail((String)"BadDataArrayException should require an array of objects");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testConstructorRequiresAnErrorTable() {
        try {
            new BadDataArrayException("aBadDataArrayException", this.obj, null);
            BadDataArrayExceptionTest.fail((String)"BadDataArrayException should require an ErrorTable");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void testGetArray() {
        Object[] objectArray = this.bdae.getArray();
        BadDataArrayExceptionTest.assertEquals((int)3, (int)objectArray.length);
    }

    public void testGetErrors() {
        ErrorTable errorTable = this.bdae.getErrors();
        ErrorList errorList = errorTable.getErrorsForIndex(0);
        BadDataArrayExceptionTest.assertEquals((int)1, (int)errorList.getErrorCount());
        errorList = errorTable.getErrorsForIndex(2);
        BadDataArrayExceptionTest.assertNull((Object)errorList);
        errorList = errorTable.getErrorsForIndex(3);
        BadDataArrayExceptionTest.assertEquals((int)2, (int)errorList.getErrorCount());
        errorList = errorTable.getErrorsForIndex(23);
        BadDataArrayExceptionTest.assertNull((Object)errorList);
    }

    public void testCreateBadDataException() {
        BadDataException badDataException = this.bdae.createBadDataException(0);
        BadDataArrayExceptionTest.assertNotNull((Object)badDataException);
        BadDataArrayExceptionTest.assertEquals((Object)this.obj[0], (Object)badDataException.getLoadedObject());
    }

    public void testCreateBadDataExceptionFromBadDataException() {
        BadDataException badDataException = this.bdae.createBadDataException(1);
        BadDataArrayExceptionTest.assertNotNull((Object)badDataException);
        BadDataArrayExceptionTest.assertEquals((Object)this.obj[1], (Object)badDataException.getLoadedObject());
    }

    public void testCreateBadDataExceptionBadIndex() {
        try {
            this.bdae.createBadDataException(23);
            BadDataArrayExceptionTest.fail((String)"Should have thrown ArrayIndexOutOfBoundsException");
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testCreateBadDataExceptionNoErrorsForIndex() {
        BadDataException badDataException = this.bdae.createBadDataException(2);
        BadDataArrayExceptionTest.assertNull((Object)badDataException);
    }
}

