/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core.access;

import com.helpsystems.common.core.access.IAbstractManager;
import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.common.core.util.ValidationHelper;
import java.io.Closeable;
import java.lang.reflect.Field;
import java.util.StringTokenizer;
import org.apache.log4j.Logger;

public abstract class AbstractManager
implements IAbstractManager {
    private static final Logger logger = Logger.getLogger(AbstractManager.class);
    private String name;
    private RelMod managerVersion;
    private RelMod interfaceVersion;
    private String suffix;

    @Override
    public final String getName() {
        return this.name;
    }

    public final void setName(String string) {
        this.setName(string, null);
    }

    public final void setName(String string, String string2) {
        if (string2 == null || string2.length() == 0) {
            this.name = string;
        } else {
            this.suffix = string2.toUpperCase();
            this.name = string + "." + this.suffix;
        }
    }

    public String getSuffix() {
        return this.suffix;
    }

    @Override
    public void managerRemoved() {
    }

    @Override
    public RelMod getManagerVersion() {
        if (this.managerVersion != null) {
            return this.managerVersion;
        }
        this.managerVersion = this.guessManagerVersion();
        return this.managerVersion;
    }

    protected void setManagerVersion(RelMod relMod) {
        ValidationHelper.checkForNull("Manager version", relMod);
        this.managerVersion = relMod;
    }

    private RelMod guessManagerVersion() {
        StringTokenizer stringTokenizer = new StringTokenizer(this.getClass().getName(), ".", false);
        if (stringTokenizer.countTokens() < 3) {
            return new RelMod(0, 0);
        }
        stringTokenizer.nextToken();
        stringTokenizer.nextToken();
        String string = stringTokenizer.nextToken();
        char c = string.charAt(0);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("com.helpsystems.");
        stringBuffer.append(string);
        stringBuffer.append(".core.");
        stringBuffer.append(Character.toUpperCase(c));
        stringBuffer.append(string.substring(1));
        stringBuffer.append("Globals");
        String string2 = stringBuffer.toString();
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(string2);
            Field field = clazz.getDeclaredField("MANAGER_VERSION");
            Integer n = (Integer)field.get(null);
            return RelMod.parse(n);
        }
        catch (Exception exception) {
            logger.debug((Object)"Unable to lookup a manager version.", (Throwable)exception);
            return new RelMod(0, 0);
        }
    }

    @Override
    public RelMod getInterfaceVersion() {
        if (this.interfaceVersion == null) {
            this.interfaceVersion = new RelMod(0, 0);
        }
        return this.interfaceVersion;
    }

    public void setInterfaceVersion(RelMod relMod) {
        ValidationHelper.checkForNull("Interface version", relMod);
        this.interfaceVersion = relMod;
    }

    public void setSuffix(String string) {
        this.suffix = string == null ? null : string.toUpperCase();
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

