/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.core;

import org.apache.log4j.Logger;

public class SkybotStackSize {
    public static final String SKYBOT_STACK_SIZE = "SKYBOT_STACK_SIZE";
    private static final long ONEK = 1024L;
    private static final long K_128 = 131072L;
    private static final long K_2048 = 0x200000L;
    private static long stackSize = 0L;
    private static boolean stackSizeLoaded = false;
    private static final Logger logger = Logger.getLogger(SkybotStackSize.class);

    public static long getStackSize() {
        if (!stackSizeLoaded) {
            SkybotStackSize.loadStackSize();
        }
        return stackSize;
    }

    private static synchronized void loadStackSize() {
        if (!stackSizeLoaded) {
            try {
                String string = System.getenv(SKYBOT_STACK_SIZE);
                if (string != null && string.trim().length() > 0) {
                    long l = Long.valueOf(string);
                    if (l < 131072L || l > 0x200000L) {
                        throw new IllegalArgumentException("SKYBOT_STACK_SIZE must be a numeric value between " + String.valueOf(131072L) + " and " + String.valueOf(0x200000L) + ". The current value is: " + String.valueOf(l));
                    }
                    stackSize = l;
                }
            }
            catch (Exception exception) {
                logger.warn((Object)"Error loading environment variable: SKYBOT_STACK_SIZE", (Throwable)exception);
            }
            stackSizeLoaded = true;
        }
    }

    public static void main(String[] stringArray) {
        System.out.println("Min Stack Size: " + String.valueOf(131072L));
        System.out.println("Max Stack Size: " + String.valueOf(0x200000L));
    }
}

