"use strict";

const axios = require('axios');

const _ = require('lodash');

async function processIncoming() {
  try {
    const axiosConfig = await bp.http.getAxiosConfigForBot(event.botId);
    const {
      data
    } = await axios.post('/mod/testing/incomingEvent', event, axiosConfig);

    if (data) {
      event.state = _.merge(event.state, data);
    }
  } catch (err) {
    console.log('Error processing', err.message);
  }
}

return processIncoming();
//# sourceMappingURL=data:application/json;charset=utf-8;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIi4wMF9yZWNvcmRlci5qcyJdLCJuYW1lcyI6WyJheGlvcyIsInJlcXVpcmUiLCJfIiwicHJvY2Vzc0luY29taW5nIiwiYXhpb3NDb25maWciLCJicCIsImh0dHAiLCJnZXRBeGlvc0NvbmZpZ0ZvckJvdCIsImV2ZW50IiwiYm90SWQiLCJkYXRhIiwicG9zdCIsInN0YXRlIiwibWVyZ2UiLCJlcnIiLCJjb25zb2xlIiwibG9nIiwibWVzc2FnZSJdLCJtYXBwaW5ncyI6Ijs7QUFBQSxNQUFNQSxLQUFLLEdBQUdDLE9BQU8sQ0FBQyxPQUFELENBQXJCOztBQUNBLE1BQU1DLENBQUMsR0FBR0QsT0FBTyxDQUFDLFFBQUQsQ0FBakI7O0FBRUEsZUFBZUUsZUFBZixHQUFpQztBQUMvQixNQUFJO0FBQ0YsVUFBTUMsV0FBVyxHQUFHLE1BQU1DLEVBQUUsQ0FBQ0MsSUFBSCxDQUFRQyxvQkFBUixDQUE2QkMsS0FBSyxDQUFDQyxLQUFuQyxDQUExQjtBQUNBLFVBQU07QUFBRUMsTUFBQUE7QUFBRixRQUFXLE1BQU1WLEtBQUssQ0FBQ1csSUFBTixDQUFXLDRCQUFYLEVBQXlDSCxLQUF6QyxFQUFnREosV0FBaEQsQ0FBdkI7O0FBRUEsUUFBSU0sSUFBSixFQUFVO0FBQ1JGLE1BQUFBLEtBQUssQ0FBQ0ksS0FBTixHQUFjVixDQUFDLENBQUNXLEtBQUYsQ0FBUUwsS0FBSyxDQUFDSSxLQUFkLEVBQXFCRixJQUFyQixDQUFkO0FBQ0Q7QUFDRixHQVBELENBT0UsT0FBT0ksR0FBUCxFQUFZO0FBQ1pDLElBQUFBLE9BQU8sQ0FBQ0MsR0FBUixDQUFZLGtCQUFaLEVBQWdDRixHQUFHLENBQUNHLE9BQXBDO0FBQ0Q7QUFDRjs7QUFFRCxPQUFPZCxlQUFlLEVBQXRCIiwic291cmNlUm9vdCI6Ii92YXIvbGliL2plbmtpbnMvd29ya3NwYWNlL2J1aWxkLWxpbnV4L21vZHVsZXMvdGVzdGluZy9zcmMvYmFja2VuZCIsInNvdXJjZXNDb250ZW50IjpbImNvbnN0IGF4aW9zID0gcmVxdWlyZSgnYXhpb3MnKVxuY29uc3QgXyA9IHJlcXVpcmUoJ2xvZGFzaCcpXG5cbmFzeW5jIGZ1bmN0aW9uIHByb2Nlc3NJbmNvbWluZygpIHtcbiAgdHJ5IHtcbiAgICBjb25zdCBheGlvc0NvbmZpZyA9IGF3YWl0IGJwLmh0dHAuZ2V0QXhpb3NDb25maWdGb3JCb3QoZXZlbnQuYm90SWQpXG4gICAgY29uc3QgeyBkYXRhIH0gPSBhd2FpdCBheGlvcy5wb3N0KCcvbW9kL3Rlc3RpbmcvaW5jb21pbmdFdmVudCcsIGV2ZW50LCBheGlvc0NvbmZpZylcblxuICAgIGlmIChkYXRhKSB7XG4gICAgICBldmVudC5zdGF0ZSA9IF8ubWVyZ2UoZXZlbnQuc3RhdGUsIGRhdGEpXG4gICAgfVxuICB9IGNhdGNoIChlcnIpIHtcbiAgICBjb25zb2xlLmxvZygnRXJyb3IgcHJvY2Vzc2luZycsIGVyci5tZXNzYWdlKVxuICB9XG59XG5cbnJldHVybiBwcm9jZXNzSW5jb21pbmcoKVxuIl19