"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Recorder = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _utils = require("./utils");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

class Recorder {
  constructor() {
    _defineProperty(this, "_lastEvent", void 0);

    _defineProperty(this, "_scenario", void 0);

    _defineProperty(this, "_specificTarget", void 0);
  }

  processIncoming(event) {
    if (!this._scenario || this._scenario.initialState) {
      return;
    }

    if (!this._specificTarget || this._specificTarget === event.target) {
      this._scenario.initialState = event.state;
    }
  }

  processCompleted(event) {
    if (!this._scenario) {
      return;
    }

    if (this._specificTarget && this._specificTarget !== event.target) {
      return;
    }

    const interactions = (0, _utils.convertLastMessages)(event.state.session.lastMessages, event.id);

    if (interactions) {
      this._lastEvent = event;

      this._scenario.steps.push(interactions);
    }
  }

  startRecording(chatUserId) {
    this._lastEvent = undefined;
    this._scenario = {
      initialState: undefined,
      finalState: undefined,
      steps: []
    };
    this._specificTarget = chatUserId.length > 0 && chatUserId;
  }

  stopRecording() {
    if (!this._scenario || !this._lastEvent) {
      return;
    }

    const finalScenario = { ..._lodash.default.pick(this._scenario, ['steps', 'initialState']),
      finalState: this._lastEvent.state
    };
    this._scenario = undefined;
    return _lodash.default.omit(finalScenario, ['initialState.session.lastMessages', 'initialState.context.jumpPoints', 'initialState.context.queue', 'finalState.session.lastMessages', 'finalState.context.jumpPoints', 'finalState.context.queue']);
  }

  isRecording() {
    return !!this._scenario;
  }

}

exports.Recorder = Recorder;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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