"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _api = _interopRequireDefault(require("./api"));

var _testing = require("./testing");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const testByBot = {};

const onServerStarted = async bp => {};

const onServerReady = async bp => {
  await (0, _api.default)(bp, testByBot);
};

const onBotMount = async (bp, botId) => {
  testByBot[botId] = new _testing.Testing(bp, botId);
};

const onBotUnmount = async (bp, botId) => {
  delete testByBot[botId];
};

const onModuleUnmount = async bp => {
  bp.http.deleteRouterForBot('testing');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onModuleUnmount,
  onBotMount,
  onBotUnmount,
  definition: {
    name: 'testing',
    menuIcon: 'polymer',
    menuText: 'Testing',
    noInterface: false,
    fullName: 'Testing',
    homepage: 'https://botpress.io',
    experimental: true
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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