"use strict";

const base = require('./_base');

function render(data) {
  const events = [];

  if (data.typing) {
    events.push({
      type: 'typing',
      value: data.typing
    });
  }

  return [...events, {
    type: 'text',
    markdown: true,
    text: data.text
  }];
}

function renderMessenger(data) {
  return [{
    type: 'typing',
    value: data.typing
  }, {
    text: data.text
  }];
}

function renderElement(data, channel) {
  if (channel === 'web' || channel === 'api' || channel === 'telegram') {
    return render(data);
  } else if (channel === 'messenger') {
    return renderMessenger(data);
  }

  return []; // TODO
}

module.exports = {
  id: 'builtin_text',
  group: 'Built-in Messages',
  title: 'Text',
  jsonSchema: {
    description: 'A regular text message with optional typing indicators and alternates',
    type: 'object',
    required: ['text'],
    properties: {
      text: {
        type: 'string',
        title: 'Message'
      },
      variations: {
        type: 'array',
        title: 'Alternates (optional)',
        items: {
          type: 'string',
          default: ''
        }
      },
      ...base.typingIndicators
    }
  },
  uiSchema: {
    text: {
      'ui:field': 'i18n_field',
      $subtype: 'textarea'
    },
    variations: {
      'ui:options': {
        orderable: false
      }
    }
  },
  computePreviewText: formData => formData.text && 'Text: ' + formData.text,
  renderElement: renderElement
};
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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