"use strict";

/**
 * Stores a variable globally, with optional expiry
 * @title Set global variable
 * @category Storage
 * @author Botpress, Inc.
 * @param {string} name - The name of the variable
 * @param {any} value - Set the value of the variable
 * @param {string} [expiry=never] - Set the expiry of the data, can be "never" or a short string like "6 hours"
 * @param {string} [output] - The state variable to output to
 */
const setGlobalVariable = async (name, value, expiry, output) => {
  const key = bp.kvs.getGlobalStorageKey(name);
  await bp.kvs.setStorageWithExpiry(event.botId, key, value, expiry);

  if (output) {
    temp[output] = value;
  }
};

return setGlobalVariable(args.name, args.value, args.expiry, args.output);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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