"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var sdk = _interopRequireWildcard(require("botpress/sdk"));

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } else { var newObj = {}; if (obj != null) { for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = Object.defineProperty && Object.getOwnPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : {}; if (desc.get || desc.set) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } } newObj.default = obj; return newObj; } }

const generateFlow = async (data, metadata) => {
  return {
    transitions: createTransitions(),
    flow: {
      nodes: createNodes(data),
      catchAll: {
        next: []
      }
    }
  };
};

const createNodes = data => {
  const nodes = [{
    name: 'entry',
    onEnter: [{
      type: sdk.NodeActionType.RunAction,
      name: 'basic-skills/call_api',
      args: {
        url: data.url,
        method: data.method,
        body: data.body,
        headers: data.headers,
        memory: data.memory,
        variable: data.variable
      }
    }],
    next: [{
      condition: 'true',
      node: '#'
    }]
  }];
  return nodes;
};

const createTransitions = () => {
  return [{
    caption: 'On success',
    condition: 'temp.valid',
    node: ''
  }, {
    caption: 'On failure',
    condition: '!temp.valid',
    node: ''
  }];
};

var _default = {
  generateFlow
};
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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