"use strict";

/**
 * Extract entities that match a slot
 * @hidden true
 * @param slotName The name of the slot to extract. (e.g. destination_from)
 * @param entitiesName The entities of the slot. (e.g. City)
 */
const slotFill = async (slotName, entitiesName) => {
  const entities = entitiesName.split(',');

  if (entities && entities.length && event.nlu.entities && event.nlu.entities.length) {
    for (const entity of event.nlu.entities) {
      if (entities.includes(entity.name)) {
        setSlot(slotName, entity);
      }
    }
  } else if (entities && entities.includes('any')) {
    const value = event.payload.text || event.preview;
    setSlot(slotName, {
      name: 'any',
      type: 'any',
      meta: {
        start: 0,
        end: value.length
      },
      data: {
        extras: {},
        value: value
      }
    });
  }
};

const setSlot = (slotName, entity) => {
  if (!session.extractedSlots[slotName]) {
    session.extractedSlots[slotName] = {
      name: slotName,
      value: entity.data.value,
      entity: entity,
      timestamp: Date.now(),
      turns: 0,
      overwritable: true,
      expiresAfterTurns: false // BETA(11.8.4): Set this to a number to expire the slot after 'N' turns

    };
    session.extractedSlots.notFound = 0;
  }
};

return slotFill(args.slotName, args.entities);
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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