"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

var _sanitizer = require("../language/sanitizer");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO if we're going to keep this, replace the training set with an inversed index or tree or at anything faster than O(n) at predict time
// this might be replaced by a knn with tweaked distance func & proper usage at predict time
class ExactMatcher {
  constructor(trainingSet) {
    this.trainingSet = trainingSet;
  }

  exactMatch(text, includedContext) {
    const filteredDataset = this.trainingSet.filter(seq => !includedContext.length || _lodash.default.intersection(seq.contexts || [], includedContext).length);
    const lowText = (0, _sanitizer.sanitize)(text.toLowerCase());

    const seq = _lodash.default.find(filteredDataset, s => (0, _sanitizer.sanitize)(s.cannonical.toLowerCase()) === lowText);

    if (seq) {
      return {
        name: seq.intent,
        confidence: 1,
        context: seq.contexts[0] // todo fix this

      };
    }
  }

}

exports.default = ExactMatcher;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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