"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _lodash = _interopRequireDefault(require("lodash"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

class Parser {
  extractLabelsFromCanonical(canonicalUtterance, intentEntities) {
    const labels = [];
    let plainText = '';
    const regex = /\[(.+?)]\((.+?)\)/g;
    let m;
    let i = 0;

    do {
      m = regex.exec(canonicalUtterance);

      if (m) {
        plainText += canonicalUtterance.substr(i, m.index - i);
        i = m.index + m[0].length;
        plainText += m[1];
        labels.push({
          start: plainText.length - m[1].length,
          end: plainText.length - 1,
          entityName: m[2],
          type: _lodash.default.get(_lodash.default.find(intentEntities, {
            name: m[2]
          }), 'type')
        });
      }
    } while (m);

    plainText += canonicalUtterance.substr(i, canonicalUtterance.length - i);
    return {
      text: plainText,
      labels: labels
    };
  }

}

exports.default = Parser;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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