"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _api = _interopRequireDefault(require("./api"));

var _db = _interopRequireDefault(require("./db"));

var _setup = _interopRequireDefault(require("./setup"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

// TODO: Cleanup old sessions
// TODO: If messages count > X, delete some
let db = undefined;

const onServerStarted = async bp => {
  db = new _db.default(bp);
  await db.initialize();
  await (0, _setup.default)(bp, db);
};

const onServerReady = async bp => {
  await (0, _api.default)(bp, db);
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('hitl.captureInMessages');
  bp.events.removeMiddleware('hitl.captureOutMessages');
  bp.http.deleteRouterForBot('hitl');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onModuleUnmount,
  definition: {
    name: 'hitl',
    menuIcon: 'feedback',
    menuText: 'HITL',
    fullName: 'Human In The Loop',
    homepage: 'https://botpress.io'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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