"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _default = async (bp, db) => {
  const router = bp.http.createRouterForBot('hitl');
  router.get('/sessions', (req, res) => {
    db.getAllSessions(req.query.onlyPaused === 'true', req.params.botId).then(sessions => res.send(sessions));
  });
  router.get('/sessions/:sessionId', (req, res) => {
    db.getSessionData(req.params.sessionId).then(messages => res.send(messages));
  });
  router.post('/sessions/:sessionId/message', (req, res) => {
    const {
      message
    } = req.body;
    db.getSessionById(req.params.sessionId).then(async session => {
      const event = bp.IO.Event({
        type: 'text',
        channel: session.channel,
        direction: 'outgoing',
        payload: {
          text: message,
          preview: message
        },
        target: session.userId,
        botId: req.params.botId
      });
      await bp.events.sendEvent(event);
      res.sendStatus(200);
    });
  }); // TODO post /sessions/:id/typing

  router.post('/sessions/:sessionId/isPaused', async (req, res) => {
    res.send((await db.isSessionPaused({
      sessionId: req.params.sessionId
    })));
  });
  router.post('/sessions/:sessionId/pause', (req, res) => {
    const {
      sessionId,
      trigger = 'operator'
    } = req.params;
    db.setSessionPaused(true, {
      sessionId
    }, trigger).then(sessionId => {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', {
        id: sessionId
      }));
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session.changed', {
        id: sessionId,
        paused: 1
      }));
    }).then(res.sendStatus(200));
  });
  router.post('/sessions/:sessionId/unpause', (req, res) => {
    const {
      sessionId,
      trigger = 'operator'
    } = req.params;
    db.setSessionPaused(false, {
      sessionId
    }, trigger).then(sessionId => {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', {
        id: sessionId
      }));
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session.changed', {
        id: sessionId,
        paused: 0
      }));
    }).then(res.sendStatus(200));
  });
  router.post('/channel/:channel/user/:userId/isPaused', async (req, res) => {
    const {
      botId,
      channel,
      userId
    } = req.params;
    res.send((await db.isSessionPaused({
      botId,
      channel,
      userId
    })));
  });
  router.post('/channel/:channel/user/:userId/pause', (req, res) => {
    const {
      botId,
      channel,
      userId,
      trigger = 'operator'
    } = req.params;
    db.setSessionPaused(true, {
      botId,
      channel,
      userId
    }, trigger).then(sessionId => {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', {
        id: sessionId
      }));
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session.changed', {
        id: sessionId,
        paused: 1
      }));
    }).then(res.sendStatus(200));
  });
  router.post('/channel/:channel/user/:userId/unpause', (req, res) => {
    const {
      botId,
      channel,
      userId,
      trigger = 'operator'
    } = req.params;
    db.setSessionPaused(false, {
      botId,
      channel,
      userId
    }, trigger).then(sessionId => {
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session', {
        id: sessionId
      }));
      bp.realtime.sendPayload(bp.RealTimePayload.forAdmins('hitl.session.changed', {
        id: sessionId,
        paused: 0
      }));
    }).then(res.sendStatus(200));
  });
};

exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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