"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

require("bluebird-global");

var _analytics = _interopRequireDefault(require("./analytics"));

var _api = _interopRequireDefault(require("./api"));

var _setup = _interopRequireDefault(require("./setup"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { default: obj }; }

const analyticsByBot = {};
const interactionsToTrack = ['message', 'text', 'button', 'template', 'quick_reply', 'postback'];

const onServerStarted = async bp => {
  await (0, _setup.default)(bp, interactionsToTrack);
};

const onServerReady = async bp => {
  await (0, _api.default)(bp, analyticsByBot);
};

const onBotMount = async (bp, botId) => {
  const analytics = new _analytics.default(bp, botId);
  analyticsByBot[botId] = analytics;
  await analytics.start();
};

const onBotUnmount = async (bp, botId) => {
  await analyticsByBot[botId].stop();
  delete analyticsByBot[botId];
};

const onModuleUnmount = async bp => {
  bp.events.removeMiddleware('analytics.incoming');
  bp.events.removeMiddleware('analytics.outgoing');
  bp.http.deleteRouterForBot('analytics');
};

const entryPoint = {
  onServerStarted,
  onServerReady,
  onBotMount,
  onBotUnmount,
  onModuleUnmount,
  definition: {
    name: 'analytics',
    fullName: 'Analytics',
    homepage: 'https://botpress.io',
    menuIcon: 'timeline',
    menuText: 'Analytics'
  }
};
var _default = entryPoint;
exports.default = _default;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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