#!/bin/sh

# Copyright (C) 2010 Help/Systems LLC, All Rights Reserved
# Instructs an on-line agent to switch to a different Enterprise Server.

PATH=$PATH:/usr/ucb

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}

# Initialize a verbose parameter
# "verbose=" to turn off verbose mode
# "verbose=-v" to turn on verbose mode
verbose=

if [ $# -eq 0 ]; then
    echo "Please provide the server's address and port"
    exit 1
fi

if [ "$1" = "-h" -o "$1" = "--help" ]; then
    echo ""
    echo "Help for: $0"
    echo ""
    echo "SWITCH - Instructs an Agent to switch to a different Enterprise Server."
    echo ""
    echo "Usage: $0 [-v] [-f config file] serverAddress:port"
    echo "If no config file is provided, then the file agent.xml is used."
    echo ""
    echo "  The -h or --help option will show command help."
    echo "  Use -v to specify verbose mode."
    echo "  Use -f to specify an Agent configuration file."
    echo ""
    echo " Example: $0 192.0.0.1:2222"
    echo ""
    exit
fi

COMMAND=switch
EXTRA_DATA=
CONFIG_FILE=agent.xml

while [ $# -gt 0 ]; do
    if [ "$1" = "-f" ]; then
        if [ $# -eq 1 ]; then
            echo "Error: A configuration file must follow the -f parameter"
            exit 1
        fi
        shift
        CONFIG_FILE=$1
    elif [ "-v" = $1 ]; then
        verbose=-v
    else
        EXTRA_DATA="${EXTRA_DATA} $1"
    fi
    shift
done

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "About to switch server for the Agent with configuration file $CONFIG_FILE ..."
./runjava.sh com.helpsystems.enterprise.peer.AgentControl ${verbose} ${CONFIG_FILE} ${COMMAND} ${EXTRA_DATA}



