#!/bin/sh

# Copyright (C) 2011 Help/Systems LLC, All Rights Reserved
# Fires off a JobSetupReport to be processed by the Server.

WORKING_DIR=`dirname $0`
cd ${WORKING_DIR}
cd ../

# ------------------------------------------------------------------------
# Function: Show Help Text                                               -
# ------------------------------------------------------------------------
showHelpText() {
  echo ""
  echo "Help for: $0"
  echo ""
  echo "jobsetupreport - Add a jobsetupreport to the report queue."
  echo ""
  echo "The -h or --help option will show command help."
  echo ""
  echo "Usage: $0 ReportParameters"
  echo ""
  echo ""
  echo " ReportParameters:"
  echo ""
  echo " -jobNames (Specify jobs to include in the report)"
  echo ""
  echo "  [jobNames/list]"
  echo "    Example 1: Report on jobs named job1 and job2"
  echo "    Command: $0 -jobNames job1 job2"
  echo ""
  echo ""
  echo " -agents (Specify agents to have all jobs that run on those agents to include"
  echo "          in the report)"
  echo ""
  echo "  [agents/list]"
  echo "    Example 2: Report on agents named agent1 and agent2"
  echo "    Command: $0 -agents agent1 agent2"
  echo ""
  echo ""
  echo " -agentGroups (Specify agentGroups to have all jobs that run on those agent"
  echo "               groups to include in the report)"
  echo ""
  echo "  [agentGropus/list]"
  echo "    Example 3: Report on agentGroups named agentGroup1 and agentGroup2"
  echo "    Command: $0 -agentGroups agentGroup1 agentGroup2 "
  echo ""
  echo ""
  echo " -tags (Specify tag list to be included in the report)"
  echo ""
  echo "  [tags/list]"
  echo "    Example 4: Report on tags named tag1 and tag2"
  echo "    Command: $0 -tags tag1 tag2"
  echo ""
  echo ""
  echo " -untagged (Specify if all untagged jobs should be included in the report)"
  echo ""
  echo "    Example 5: Report on all untagged jobs  "
  echo "    Command: $0 -untagged"
  echo ""
  echo ""
  echo " -userName (Specify the user name who will generate the report)"
  echo ""
  echo " [userName] - If no -userName option is given the report will"
  echo "              be generated by administrator user."
  echo "     Example 6: Specify the user name who generates the report.  The report"
  echo "                in this example will list all jobs since no other parameters"
  echo "                were used."
  echo ""
  echo "     Command: $0 -userName username"
  echo ""
  echo ""
  echo " -f  (Specify an agent configuration file to be used to start the report)"
  echo ""
  echo "  [filename] - If no -f option is given the agent configuration file defaults"
  echo "               to agent.xml."
  echo "    Example 7: Specify agent other than default, report on job named job1"
  echo "    Command: $0 -f myconfig.xml -jobNames job1"
  echo ""
  echo "  -emailToAddress  (Specify email addresses to send the report)"
  echo "  [emailToAddress/list]"
  echo ""
  echo "    Example 8:  Send a report to admin@mycompany.com, company@mycompany.com email addresses "
  echo "    Command: $0 -emailToAddress admin@mycompany.com company@mycompany.com "
  echo "     If no -emailToAddress option is given the report will not be sent "
  echo ""
  echo "  -emailToNotificationList  (Specify notification lists to send the report)"
  echo "  [emailToNotificationList/list]"
  echo ""
  echo "    Example 9:  Send a report an email to notification lists "
  echo "    Command: $0 -emailToNotificationList notificationList1 notificationList2 "
  echo "     If no -emailToNotificationList option is given the report will not be sent "
  echo ""
  echo "  -emailToCurrentUser  (Specify current user email address to send the report)"
  echo "  [emailToCurrentUser]"
  echo ""
  echo "    Example 10:  Send a report to current user email address "
  echo "    Command: $0 -userName automateuser -emailToCurrentUser yes "
  echo "     If no -emailToCurrentUser option is given the report will not be sent "
  echo ""
  echo "  [reportFilePath]"
  echo "  This parameter is for the file system that the Automate Schedule server is running "
  echo "  on, not the agent itself."
  echo ""
  echo "    Example 11A:  Copy the report when the Automate Schedule server is running on a Windows system "
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule "
  echo ""
  echo "    Example 11B:  Copy the report when the Automate Schedule server is running on a Unix system. "
  echo "    Command: $0 -reportFilePath /home/a_user "
  echo "     If -reportFilePath is not specified the report will not be copied "
  echo ""
  echo "  -reportFileName  (Specify file name to copy the report)"
  echo "  [reportFileName]"
  echo ""
  echo "    Example 12A:  Copy report to this file when the Automate Schedule server is running on a Windows system."
  echo "    Command: $0 -reportFilePath C:\\\\automateschedule -reportFileName report.pdf "
  echo "    Example 12B:  Copy report to this file when the Automate Schedule server is running on a Unix system."
  echo "    Command: $0 -reportFilePath /home/a_user -reportFileName report.pdf "
  echo "     If -reportFileName is not specified generated name will be used "
  echo ""  
  echo ""
  echo "Copyright (C) 2011 Help/Systems LLC, All Rights Reserved."
}

noConfigFile() {
  echo "Error: A configuration file must follow the -f parameter"
}

COMMAND=REPORT
CONFIG_FILE=agent.xml
# For other reports, change the "0" to the report id, ie "100", "1002", etc
REPORT_NUM=100
OUTPUT_TYPE=0
MAINCLASS=com.helpsystems.enterprise.peer.AgentControl

allArgs=$@

for i in ${@}
do
	if [ "$i" = "-h" -o "$i" = "--help" ]; then
		showHelpText
		exit 1
	fi
done

if [ "$1" = "-f" ]; then
	if [ "$2" = "" ]; then
		noConfigFile
		exit 1
	fi
	CONFIG_FILE=$2
fi 

if [ ! -f ${CONFIG_FILE} ]; then
    echo "The config file ${CONFIG_FILE} is missing. Command unsuccessful."
    exit 1
fi

if [ ! -r ${CONFIG_FILE} ]; then
    echo "The config file $CONFIG_FILE is not readable by the current user."
    exit 1
fi

echo "Generating report with agent configuration file $CONFIG_FILE ..."
# ./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" ${FROM_DATE} ${TO_DATE}
./runjava.sh ${MAINCLASS} ${CONFIG_FILE} ${COMMAND} "${REPORT_NUM}" "${OUTPUT_TYPE}" "$@"
