/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access.service;

import com.helpsystems.common.access.JdbcPoolManager;
import com.helpsystems.common.access.service.JdbcService;
import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.access.service.RBTUSERPoolableConnectionFactory;
import com.helpsystems.common.core.encryption.EncryptUtil;
import com.helpsystems.common.core.service.Service;
import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.service.ServiceException;
import com.helpsystems.common.core.service.ServiceStarter;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Properties;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DriverManagerConnectionFactory;
import org.apache.commons.dbcp.PoolableConnectionFactory;
import org.apache.commons.dbcp.PoolingDriver;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.apache.log4j.Logger;

public class JdbcServiceStarter
implements ServiceStarter {
    public static final String DBCP_URL_PREFIX = "jdbc:apache:commons:dbcp:";
    private static final Logger logger = Logger.getLogger(JdbcServiceStarter.class);
    private GenericObjectPool connectionPool;
    private EncryptUtil decoder;

    public Service startService(ServiceDescriptor serviceDescriptor) throws ServiceException {
        if (serviceDescriptor instanceof JdbcServiceDescriptor) {
            return this.startJdbcService((JdbcServiceDescriptor)serviceDescriptor);
        }
        throw new ServiceException("The service descriptor passed in is incompatible with this ServiceStarter.");
    }

    protected Service startJdbcService(JdbcServiceDescriptor jdbcServiceDescriptor) throws ServiceException {
        Object object;
        if (jdbcServiceDescriptor == null) {
            throw new NullPointerException("The service descriptor passed in is null.");
        }
        String string = jdbcServiceDescriptor.getDriverClassname();
        String string2 = jdbcServiceDescriptor.getUrl();
        String string3 = jdbcServiceDescriptor.getUsername();
        String string4 = jdbcServiceDescriptor.getEncryptedPassword();
        if (string == null) {
            throw new ServiceException("The classname within the descriptor " + jdbcServiceDescriptor.getName() + " is null.");
        }
        if (string2 == null) {
            throw new ServiceException("The url within the descriptor " + jdbcServiceDescriptor.getName() + " is null.");
        }
        String string5 = null;
        Properties properties = new Properties();
        if (string3 != null) {
            properties.setProperty("user", string3);
        }
        if (string4 != null && this.decoder != null) {
            try {
                string5 = this.decoder.decode(string4);
            }
            catch (Exception exception) {
                throw new ServiceException("Unable to decrypt the JDBC password for service " + jdbcServiceDescriptor.getName(), (Throwable)exception);
            }
        } else {
            string5 = string4;
        }
        if (string5 != null) {
            properties.setProperty("password", string5);
        }
        String string6 = jdbcServiceDescriptor.getName();
        String string7 = jdbcServiceDescriptor.getTestQuery();
        boolean bl = jdbcServiceDescriptor.getAutoCommit();
        try {
            RBTUSERPoolableConnectionFactory rBTUSERPoolableConnectionFactory;
            object = Class.forName(string);
            Driver driver = (Driver)((Class)object).newInstance();
            DriverManager.registerDriver(driver);
            this.connectionPool = null;
            this.connectionPool = new GenericObjectPool(null);
            DriverManagerConnectionFactory driverManagerConnectionFactory = new DriverManagerConnectionFactory(string2, properties);
            if (jdbcServiceDescriptor.getSwapToRBTUSER()) {
                rBTUSERPoolableConnectionFactory = new RBTUSERPoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)this.connectionPool, null, string7, false, bl);
                rBTUSERPoolableConnectionFactory.setRobotSystemLibraryName("RBTSYSLIB");
            } else {
                new PoolableConnectionFactory((ConnectionFactory)driverManagerConnectionFactory, (ObjectPool)this.connectionPool, null, string7, false, bl);
            }
            rBTUSERPoolableConnectionFactory = new PoolingDriver();
            rBTUSERPoolableConnectionFactory.registerPool(string6, (ObjectPool)this.connectionPool);
            int n = jdbcServiceDescriptor.getMaxConnections();
            this.connectionPool.setMaxActive(n);
            this.connectionPool.setMaxIdle(jdbcServiceDescriptor.getMaxIdleConnections());
            this.connectionPool.setMinIdle(1);
            this.connectionPool.setMaxWait(3000L);
            this.connectionPool.setMinEvictableIdleTimeMillis(jdbcServiceDescriptor.getMinEvictableIdleTimeMillis());
            this.connectionPool.setWhenExhaustedAction((byte)0);
            if (string7 != null) {
                this.connectionPool.setTestOnBorrow(true);
                this.connectionPool.setTestOnReturn(false);
                this.connectionPool.setTestWhileIdle(true);
                this.connectionPool.setTimeBetweenEvictionRunsMillis(60000L);
            }
            Object object2 = this.connectionPool.borrowObject();
            this.connectionPool.returnObject(object2);
            logger.debug((Object)("JdbcServiceStarter service has started: " + jdbcServiceDescriptor.getName()));
        }
        catch (Exception exception) {
            throw new ServiceException("Unable to start the service " + string6, (Throwable)exception);
        }
        JdbcPoolManager.getInstance().registerPool(jdbcServiceDescriptor.getName(), (ObjectPool)this.connectionPool, jdbcServiceDescriptor);
        object = new JdbcService();
        object.setDescriptor((ServiceDescriptor)jdbcServiceDescriptor);
        object.setStatus(1);
        ((JdbcService)((Object)object)).setJdbcUrl(DBCP_URL_PREFIX + jdbcServiceDescriptor.getName());
        return object;
    }

    public void stopService(Service service) throws ServiceException {
        if (service == null) {
            logger.debug((Object)"JdbcServiceStarter service is stopping null service.");
            return;
        }
        ServiceDescriptor serviceDescriptor = service.getDescriptor();
        logger.debug((Object)("JdbcServiceStarter service is stopping service descriptor: " + serviceDescriptor.getName()));
        if (!(serviceDescriptor instanceof JdbcServiceDescriptor)) {
            throw new ServiceException("The service passed in is incompatible with this ServiceStarter.");
        }
        try {
            this.connectionPool.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void useEncryption(EncryptUtil encryptUtil) {
        this.decoder = encryptUtil;
    }
}

