/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.filter.SQLInjectorFilterCriteria;
import com.helpsystems.common.core.filter.DataFilter;
import com.helpsystems.common.core.filter.FilterCriteria;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class SQLWhereClause {
    private static final Logger logger = Logger.getLogger(SQLWhereClause.class);
    private static final String SQL_AND = " and ";
    private static final String SQL_OR = " or ";
    private static final String SQL_NOT = " not ";

    public static String getSQL(DataFilter dataFilter, boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        if (dataFilter.isEmpty()) {
            stringBuffer.append("1=1");
        } else {
            DataFilter dataFilter2;
            int n;
            for (n = 0; n < dataFilter.filterSize(); ++n) {
                dataFilter2 = dataFilter.getFilter(n);
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(SQLWhereClause.getSQL(dataFilter2, true));
                    continue;
                }
                stringBuffer.append(SQLWhereClause.getConjunctionString(dataFilter));
                stringBuffer.append(SQLWhereClause.getSQL(dataFilter2, true));
            }
            for (n = 0; n < dataFilter.criteriaSize(); ++n) {
                dataFilter2 = dataFilter.getCriteria(n);
                if (stringBuffer.length() == 0) {
                    if (dataFilter.getConjunction() == 2) {
                        stringBuffer.append(SQLWhereClause.getConjunctionString(dataFilter));
                    }
                    stringBuffer.append(SQLWhereClause.getSubClause((FilterCriteria)dataFilter2));
                    continue;
                }
                stringBuffer.append(SQLWhereClause.getConjunctionString(dataFilter));
                stringBuffer.append(SQLWhereClause.getSubClause((FilterCriteria)dataFilter2));
            }
            if (dataFilter.hasSQLString()) {
                if (stringBuffer.length() == 0) {
                    stringBuffer.append(dataFilter.getSQLString());
                } else {
                    stringBuffer.append(SQLWhereClause.getConjunctionString(dataFilter));
                    stringBuffer.append(dataFilter.getSQLString());
                }
            }
        }
        if (bl) {
            stringBuffer.insert(0, "(");
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    private static String getConjunctionString(DataFilter dataFilter) {
        switch (dataFilter.getConjunction()) {
            case 0: {
                return SQL_AND;
            }
            case 1: {
                return SQL_OR;
            }
            case 2: {
                return SQL_NOT;
            }
        }
        return SQL_OR;
    }

    public static String getFieldName(FilterCriteria filterCriteria) {
        if (filterCriteria.isIgnoreCase()) {
            StringBuffer stringBuffer = new StringBuffer(" UPPER(");
            stringBuffer.append(filterCriteria.getFieldName());
            stringBuffer.append(")");
            return stringBuffer.toString();
        }
        return filterCriteria.getFieldName();
    }

    public static Serializable getValue(FilterCriteria filterCriteria) {
        Serializable serializable = filterCriteria.getValue();
        if (filterCriteria.isIgnoreCase() && serializable instanceof String) {
            return ((String)((Object)serializable)).toUpperCase();
        }
        return serializable;
    }

    private static String getSubClause(FilterCriteria filterCriteria) {
        StringBuffer stringBuffer = new StringBuffer();
        String string = null;
        if (filterCriteria.getOperator() == 6 || filterCriteria.getOperator() == 9 || filterCriteria.getOperator() == 10 || filterCriteria.getOperator() == 11) {
            string = "upper";
        }
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("(");
        }
        stringBuffer.append(SQLWhereClause.getFieldName(filterCriteria));
        if (string != null) {
            stringBuffer.append(")");
        }
        stringBuffer.append(" ");
        stringBuffer.append(SQLWhereClause.getSqlOperator(filterCriteria.getOperator()));
        if (filterCriteria instanceof SQLInjectorFilterCriteria) {
            stringBuffer.append(((SQLInjectorFilterCriteria)filterCriteria).getSQLExpression());
        } else {
            Serializable serializable = SQLWhereClause.getValue(filterCriteria);
            if (filterCriteria.getOperator() == 7 || filterCriteria.getOperator() == 8) {
                int n = 1;
                if (serializable instanceof Object[]) {
                    Object[] objectArray = (Object[])serializable;
                    n = objectArray.length;
                }
                stringBuffer.append("(");
                for (int i = 0; i < n; ++i) {
                    if (i > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append("?");
                }
                stringBuffer.append(")");
            } else if (filterCriteria.isValueAField()) {
                stringBuffer.append(serializable);
            } else {
                stringBuffer.append(" ?");
            }
        }
        return stringBuffer.toString();
    }

    static String getSqlOperator(int n) {
        switch (n) {
            case 0: {
                return "=";
            }
            case 1: {
                return "<>";
            }
            case 2: {
                return ">=";
            }
            case 3: {
                return "<=";
            }
            case 4: {
                return ">";
            }
            case 5: {
                return "<";
            }
            case 6: 
            case 9: {
                return "like";
            }
            case 10: 
            case 11: {
                return "not like";
            }
            case 7: {
                return "in";
            }
            case 8: {
                return "not in";
            }
        }
        throw new IllegalArgumentException("Unknown operator value: " + n);
    }

    public static int prepareSQLWhereClause(PreparedStatement preparedStatement, int n, DataFilter dataFilter) throws SQLException {
        DataFilter dataFilter2;
        int n2;
        int n3 = n;
        for (n2 = 0; n2 < dataFilter.filterSize(); ++n2) {
            dataFilter2 = dataFilter.getFilter(n2);
            n3 = SQLWhereClause.prepareSQLWhereClause(preparedStatement, n3, dataFilter2);
        }
        for (n2 = 0; n2 < dataFilter.criteriaSize(); ++n2) {
            dataFilter2 = dataFilter.getCriteria(n2);
            if (dataFilter2 instanceof SQLInjectorFilterCriteria) continue;
            Object object = SQLWhereClause.getValue((FilterCriteria)dataFilter2);
            if ((dataFilter2.getOperator() == 6 || dataFilter2.getOperator() == 10) && object instanceof String) {
                object = ((String)object + "%").toUpperCase();
            }
            if ((dataFilter2.getOperator() == 9 || dataFilter2.getOperator() == 11) && object instanceof String) {
                object = ("%" + (String)object + "%").toUpperCase();
            }
            if (dataFilter2.getOperator() == 7 || dataFilter2.getOperator() == 8) {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("(");
                Object[] objectArray = null;
                objectArray = object instanceof Object[] ? (Object[])object : new Object[]{object};
                for (int i = 0; i < objectArray.length; ++i) {
                    SQLWhereClause.checkUnicode(preparedStatement, n3, dataFilter2.getFieldName());
                    if (logger.isTraceEnabled() && System.getProperty("common.java.trace.sql") != null) {
                        logger.trace((Object)("Preparing parameter " + n3 + " with value: " + objectArray[i]));
                    }
                    preparedStatement.setObject(n3, objectArray[i]);
                    ++n3;
                }
                continue;
            }
            SQLWhereClause.checkUnicode(preparedStatement, n3, dataFilter2.getFieldName());
            if (dataFilter2.isValueAField()) continue;
            if (logger.isTraceEnabled() && System.getProperty("common.java.trace.sql") != null) {
                logger.trace((Object)("Preparing parameter " + n3 + " with value: " + object));
            }
            preparedStatement.setObject(n3, object);
            ++n3;
        }
        return n3;
    }

    private static void checkUnicode(PreparedStatement preparedStatement, int n, String string) {
        if (preparedStatement instanceof AbstractDatabaseManager.WrappedPreparedStatement) {
            AbstractDatabaseManager.WrappedPreparedStatement wrappedPreparedStatement = (AbstractDatabaseManager.WrappedPreparedStatement)preparedStatement;
            if (AbstractDatabaseManager.isUnicodeField(string)) {
                wrappedPreparedStatement.defineUnicodeParm(n, string);
            }
        }
    }
}

