/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.AbstractDatabaseManager;
import com.helpsystems.common.access.BusinessObjectGenerator;
import com.helpsystems.common.access.ResultSetDataSet;
import com.helpsystems.common.core.access.BadDataArrayException;
import com.helpsystems.common.core.access.DataSetException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.access.dataset.DataSetClosedException;
import com.helpsystems.common.core.access.dataset.ReloadException;
import com.helpsystems.common.core.access.dataset.ReloadableDataSet;
import com.helpsystems.common.core.util.ValidationHelper;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class ReloadableResultSetDataSet
extends ResultSetDataSet
implements ReloadableDataSet {
    private static final Logger logger = Logger.getLogger(ReloadableResultSetDataSet.class);
    private PreparedStatement dataPS;
    private PreparedStatement countPS;
    private boolean doingReload;
    private Object waitingRoom;

    ReloadableResultSetDataSet(PreparedStatement preparedStatement, PreparedStatement preparedStatement2, ResultSet resultSet, BusinessObjectGenerator businessObjectGenerator) throws DataSetException {
        super(resultSet, businessObjectGenerator);
        ValidationHelper.checkForNull((String)"Data PreparedStatement", (Object)preparedStatement);
        this.dataPS = preparedStatement;
        this.countPS = preparedStatement2;
        this.waitingRoom = new Object();
    }

    @Override
    public void close() throws DataSetException {
        if (this.dataPS != null) {
            AbstractDatabaseManager.closeEm(null, this.dataPS, null);
            this.dataPS = null;
        }
        if (this.countPS != null) {
            AbstractDatabaseManager.closeEm(null, this.dataPS, null);
            this.countPS = null;
        }
        super.close();
    }

    @Override
    public Object[] get(int n, int n2) throws DataSetException, BadDataArrayException {
        this.waitIfReloading();
        return super.get(n, n2);
    }

    @Override
    public int size() throws DataSetException {
        this.waitIfReloading();
        return super.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int reload() throws ResourceUnavailableException, DataSetException {
        if (this.dataPS == null) {
            throw new DataSetClosedException("");
        }
        Object object = this.waitingRoom;
        synchronized (object) {
            this.doingReload = true;
        }
        this.size = -1;
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            this.rs = null;
            if (this.countPS != null) {
                object = this.countPS.executeQuery();
                if (object.next()) {
                    this.size = object.getInt(1);
                }
                object.close();
            }
            this.rs = this.dataPS.executeQuery();
            this.validateResultSet();
        }
        catch (SQLException sQLException) {
            throw new ReloadException("Unable to reload the data set.", (Throwable)sQLException);
        }
        finally {
            this.doingReload = false;
            Object object2 = this.waitingRoom;
            synchronized (object2) {
                this.waitingRoom.notifyAll();
            }
        }
        if (this.size > -1) {
            try {
                this.size = ReloadableResultSetDataSet.confirmOrAdjustSize(this.size, this.rs);
                this.rs.beforeFirst();
                return this.size;
            }
            catch (SQLException sQLException) {
                String string = "Unable to confirm the size of the result set.";
                logger.debug((Object)string, (Throwable)sQLException);
            }
        }
        return this.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitIfReloading() throws DataSetException {
        Object object = this.waitingRoom;
        synchronized (object) {
            if (this.doingReload) {
                try {
                    this.waitingRoom.wait();
                }
                catch (InterruptedException interruptedException) {
                    throw new DataSetException("Interrupted while waiting for a data set reload.");
                }
            }
        }
    }
}

