/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.access;

import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import java.util.Collection;
import java.util.Hashtable;
import org.apache.commons.pool.ObjectPool;

public class JdbcPoolManager {
    private Hashtable<String, ObjectPool> poolTable;
    private Hashtable<String, JdbcServiceDescriptor> infoTable;
    private Hashtable<String, Hashtable<Long, StackTraceElement[]>> borrowerTable;
    private static JdbcPoolManager theInstance;

    private JdbcPoolManager() {
        theInstance = this;
        this.poolTable = new Hashtable();
        this.infoTable = new Hashtable();
        this.borrowerTable = new Hashtable();
    }

    public static JdbcPoolManager getInstance() {
        if (theInstance == null) {
            new JdbcPoolManager();
        }
        return theInstance;
    }

    public JdbcServiceDescriptor getInfo(String string) {
        return this.infoTable.get(string);
    }

    public ObjectPool getPool(String string) {
        return this.poolTable.get(string);
    }

    public void registerPool(String string, ObjectPool objectPool, JdbcServiceDescriptor jdbcServiceDescriptor) {
        if (objectPool == null) {
            throw new NullPointerException("The pool passed in was null.");
        }
        if (string == null) {
            throw new NullPointerException("The name passed in was null.");
        }
        this.poolTable.put(string, objectPool);
        this.infoTable.put(string, jdbcServiceDescriptor);
    }

    public Collection getPoolNames() {
        return this.poolTable.keySet();
    }

    public Collection getPools() {
        return this.poolTable.values();
    }

    public ObjectPool removePool(String string) {
        this.infoTable.remove(string);
        return this.poolTable.remove(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionBorrowed(String string, Long l, StackTraceElement[] stackTraceElementArray) {
        Hashtable<String, Hashtable<Long, StackTraceElement[]>> hashtable = this.borrowerTable;
        synchronized (hashtable) {
            Hashtable<Long, Object> hashtable2 = this.borrowerTable.get(string);
            if (hashtable2 == null) {
                hashtable2 = new Hashtable();
                this.borrowerTable.put(string, hashtable2);
            }
            hashtable2.put(l, stackTraceElementArray);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionReleased(String string, Long l) {
        Hashtable<String, Hashtable<Long, StackTraceElement[]>> hashtable = this.borrowerTable;
        synchronized (hashtable) {
            Hashtable<Long, StackTraceElement[]> hashtable2 = this.borrowerTable.get(string);
            if (hashtable2 != null) {
                hashtable2.remove(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Hashtable<Long, StackTraceElement[]> getBorrowers(String string) {
        Hashtable<Long, StackTraceElement[]> hashtable = new Hashtable<Long, StackTraceElement[]>();
        Hashtable<String, Hashtable<Long, StackTraceElement[]>> hashtable2 = this.borrowerTable;
        synchronized (hashtable2) {
            Hashtable<Long, StackTraceElement[]> hashtable3 = this.borrowerTable.get(string);
            if (hashtable3 != null) {
                hashtable.putAll(hashtable3);
            }
        }
        return hashtable;
    }
}

