/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.common.server.auth;

import com.helpsystems.common.core.access.AbstractManager;
import com.helpsystems.common.core.access.ActionFailedException;
import com.helpsystems.common.core.access.ResourceUnavailableException;
import com.helpsystems.common.core.dm.ILoginHandlerAM;
import com.helpsystems.common.core.encryption.EncryptUtil;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.xml.bind.DatatypeConverter;

public abstract class AbstractLoginHandlerAM
extends AbstractManager
implements ILoginHandlerAM {
    protected String serverName;
    private transient EncryptUtil encryptUtil;

    public AbstractLoginHandlerAM(String string) {
        this.serverName = string;
        this.setName("COMMON.ILoginHandlerAM");
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String string) {
        this.serverName = string;
    }

    public void setEncryptUtil(EncryptUtil encryptUtil) {
        this.encryptUtil = encryptUtil;
    }

    protected char[] decodePassword(String string) throws IOException, ActionFailedException {
        if (this.encryptUtil == null) {
            byte[] byArray = DatatypeConverter.parseBase64Binary((String)string);
            return EncryptUtil.convertUTF8ByteToChar((byte[])byArray);
        }
        return this.encryptUtil.decodeBase64ToChar(string);
    }

    public String validateUser(String string, String string2) throws ResourceUnavailableException {
        char[] cArray = null;
        try {
            cArray = this.decodePassword(string2);
        }
        catch (Exception exception) {
            throw new ResourceUnavailableException("Unable to decode the password.", (Throwable)exception);
        }
        return this.validateUser(string, cArray);
    }

    public abstract String validateUser(String var1, char[] var2) throws ResourceUnavailableException;

    public boolean isSystemAvailable() {
        try {
            InetAddress.getByName(this.serverName);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean testPort(int n) {
        Socket socket = null;
        try {
            socket = new Socket(this.serverName, n);
            boolean bl = true;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                socket.close();
            }
            catch (Exception exception) {}
        }
    }
}

