/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer.preconditions;

import com.helpsystems.enterprise.core.busobj.JobCondition;
import com.helpsystems.enterprise.core.util.WildCardUtils;
import com.helpsystems.enterprise.peer.FileTransterUtils;
import com.helpsystems.enterprise.peer.preconditions.AbstractJobConditionValidator;
import java.io.File;
import java.util.List;

public class CheckFile
extends AbstractJobConditionValidator {
    public boolean checkCondition(JobCondition jobCondition) {
        return jobCondition.isConditionChoice() ? this.existsFile(jobCondition) : !this.existsFile(jobCondition);
    }

    public boolean existsFile(JobCondition jobCondition) {
        String string = jobCondition.getConditionData().trim();
        if (string.indexOf(42) == -1) {
            File file = new File(string);
            return file.exists() && file.isFile();
        }
        String string2 = FileTransterUtils.getSystemWildCardFromSystemFileName(string);
        String string3 = WildCardUtils.wildcardToRegexpForFileSystem((String)string2);
        File file = new File(string).getParentFile();
        if (!file.exists()) {
            return false;
        }
        List list = WildCardUtils.getFileListByRegExp((File)file, (String)string3, (boolean)false, (boolean)true);
        return !list.isEmpty();
    }

    public String toString(JobCondition jobCondition) {
        StringBuffer stringBuffer = new StringBuffer("Checking Existence of File Or Directory ");
        stringBuffer.append(jobCondition.getConditionData().trim());
        stringBuffer.append(".");
        return stringBuffer.toString();
    }
}

