/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.access.service.JdbcServiceDescriptor;
import com.helpsystems.common.core.access.ManagerRegistry;
import com.helpsystems.common.core.util.InterruptibleProcess;
import com.helpsystems.common.tl.PeerID;
import com.helpsystems.enterprise.core.busobj.EnterpriseService;
import com.helpsystems.enterprise.core.db.PostgresqlDB;
import com.helpsystems.enterprise.core.dm.EnterpriseServerAM;
import com.helpsystems.enterprise.core.util.UnacodeMash;
import com.helpsystems.enterprise.peer.ServicePeer;
import com.helpsystems.enterprise.peer.WindowsAgentAM;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import org.apache.commons.net.util.Base64;
import org.apache.log4j.Logger;

class StandbyChecker
implements InterruptibleProcess,
EnterpriseService {
    private static Logger logger = Logger.getLogger(StandbyChecker.class);
    private static final String SERVICE_NAME = "Standby Checker";
    public static final String THREAD_NAME = "Standby Checker thread";
    private boolean isShutdown = false;
    private PeerID serverPeerID = null;
    private ServicePeer servicePeer = null;
    private String adminPwd = null;
    private String relmod = null;
    private int localServerPort = 0;

    public String getServiceStatistics() {
        return "No information available";
    }

    public void setServicePort(int n) {
    }

    public int getServicePort() {
        return -1235;
    }

    public void registerServiceToServerPeer(PeerID peerID) {
        this.serverPeerID = peerID;
    }

    public String getServiceName() {
        return SERVICE_NAME;
    }

    public String getServiceLogFileName() {
        return StandbyChecker.getLogFileName();
    }

    public String getServiceInfo() {
        return "Service Info Not Available";
    }

    public void startService() {
        this.startThread();
    }

    private Thread startThread() {
        Thread thread = new Thread(new StandbyProcessor());
        thread.setName("StandbyChecker Thread");
        thread.setDaemon(true);
        System.out.println("Starting thread: " + thread.getName());
        thread.start();
        return thread;
    }

    public void interrupt() {
        this.isShutdown = true;
        try {
            Thread.currentThread().interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isInterruptible() {
        return true;
    }

    public boolean wasInterrupted() {
        return this.isShutdown;
    }

    public boolean getLocalService() {
        return false;
    }

    public void setAdminPwd(String string) {
        this.adminPwd = string;
    }

    public void setRelMod(String string) {
        this.relmod = string;
    }

    public void setServicePeer(ServicePeer servicePeer) {
        this.servicePeer = servicePeer;
    }

    public void setLocalServerPort(int n) {
        this.localServerPort = n;
    }

    private static String getLogFileName() {
        String string = System.getenv("SERVER_PATH");
        StringBuffer stringBuffer = new StringBuffer("entlogs");
        stringBuffer.append(File.separator);
        stringBuffer.append("Enterprise");
        stringBuffer.append(File.separator);
        stringBuffer.append("standby_checker.log");
        File file = new File(string, stringBuffer.toString());
        return file.getAbsolutePath();
    }

    private void writeOutputFile(JdbcServiceDescriptor jdbcServiceDescriptor) throws IOException {
        Object object;
        int n = PostgresqlDB.getDatabasePortFromURL((String)jdbcServiceDescriptor.getUrl());
        String string = jdbcServiceDescriptor.getUsername();
        String string2 = null;
        try {
            object = UnacodeMash.getForDataManagers();
            string2 = object.decode(jdbcServiceDescriptor.getEncryptedPassword());
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to decrypt the JDBC password.", exception);
        }
        object = System.getenv("SERVER_PATH");
        StringBuffer stringBuffer = new StringBuffer("tmp");
        stringBuffer.append(File.separator);
        stringBuffer.append("checker_output.ini");
        File file = new File((String)object, stringBuffer.toString());
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
        bufferedWriter.write("[dbsettings]\n");
        bufferedWriter.write("port=" + n + "\n");
        bufferedWriter.write("user=" + string + "\n");
        bufferedWriter.write("password=" + string2 + "\n");
        ((Writer)bufferedWriter).close();
    }

    private void writeErrorFile(Exception exception) {
        try {
            String string = System.getenv("SERVER_PATH");
            StringBuffer stringBuffer = new StringBuffer("tmp");
            stringBuffer.append(File.separator);
            stringBuffer.append("checker_output.err");
            File file = new File(string, stringBuffer.toString());
            BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
            bufferedWriter.write("[errors]\n");
            bufferedWriter.write("error=\"" + exception.getMessage() + "\"\n");
            ((Writer)bufferedWriter).close();
        }
        catch (IOException iOException) {
            logger.error((Object)exception);
        }
    }

    public static String getArchForPostgresqlReplication() {
        String string = System.getProperty("os.name").toLowerCase();
        if (string.indexOf("win") >= 0) {
            WindowsAgentAM windowsAgentAM = (WindowsAgentAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.WindowsAgentAM");
            if (windowsAgentAM.is64BitWindowsOS()) {
                return "WIN64";
            }
            return "WIN32";
        }
        return System.getProperty("os.arch");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getAdminPwdViaFile(String string) {
        String string2 = string;
        String string3 = System.getenv("SERVER_PATH");
        File file = new File(string3, string);
        if (file.exists()) {
            FileInputStream fileInputStream = null;
            BufferedReader bufferedReader = null;
            try {
                StringBuilder stringBuilder = new StringBuilder();
                fileInputStream = new FileInputStream(file);
                bufferedReader = new BufferedReader(new InputStreamReader((InputStream)fileInputStream, "utf8"));
                String string4 = bufferedReader.readLine();
                while (string4 != null) {
                    stringBuilder.append(string4);
                    string4 = bufferedReader.readLine();
                }
                byte[] byArray = Base64.decodeBase64((String)stringBuilder.toString());
                string2 = new String(byArray, "UTF-8");
            }
            catch (Exception exception) {
                logger.error((Object)exception);
                exception.printStackTrace();
            }
            finally {
                try {
                    bufferedReader.close();
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
            if (!file.delete()) {
                logger.warn((Object)("The file " + file.getAbsolutePath() + " was NOT deleted."));
            }
        }
        return string2;
    }

    class StandbyProcessor
    implements Runnable {
        StandbyProcessor() {
        }

        @Override
        public void run() {
            int n = 0;
            try {
                if (StandbyChecker.this.adminPwd != null) {
                    EnterpriseServerAM enterpriseServerAM = (EnterpriseServerAM)ManagerRegistry.getManagerOrFail((String)"ENTERPRISE.EnterpriseServerAM");
                    if (!EnterpriseServerAM.DM_VERSION.equals((Object)enterpriseServerAM.getManagerVersion())) {
                        throw new IllegalArgumentException("The Master server is not the same Automate Schedule version as this server.");
                    }
                    if ("FINALIZE".equals(StandbyChecker.this.adminPwd)) {
                        logger.info((Object)"About to finish Standby Setup ...");
                        enterpriseServerAM.finishStandbySetup(StandbyChecker.this.servicePeer.getRemotePeerID(), StandbyChecker.this.localServerPort);
                        do {
                            Thread.sleep(20000L);
                        } while (enterpriseServerAM.isFinishStandbySetupThreadActive());
                        logger.info((Object)"Standby Setup has finished.");
                    } else {
                        logger.info((Object)"About to verify Standby Connection ...");
                        StandbyChecker.this.adminPwd = StandbyChecker.this.getAdminPwdViaFile(StandbyChecker.this.adminPwd);
                        String string = StandbyChecker.getArchForPostgresqlReplication();
                        String string2 = System.getProperty("os.name");
                        enterpriseServerAM.verifyStandbyConnection(StandbyChecker.this.adminPwd, StandbyChecker.this.relmod, string, string2);
                        logger.info((Object)"About to write to output file ...");
                        StandbyChecker.this.writeOutputFile((JdbcServiceDescriptor)enterpriseServerAM.retrieveDBConnInfo());
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                logger.info((Object)illegalArgumentException);
                StandbyChecker.this.writeErrorFile(illegalArgumentException);
                System.exit(10);
            }
            catch (Exception exception) {
                logger.info((Object)exception);
                StandbyChecker.this.writeErrorFile(exception);
                System.exit(11);
            }
            System.exit(n);
        }
    }
}

