/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.util.ValidationHelper;

public class MulticastMessage {
    public static final String SEPARATOR = "_#_";
    private String source;
    private String destination;
    private String message;

    public MulticastMessage() {
    }

    public MulticastMessage(String string, String string2, String string3) {
        this.setSource(string);
        this.setDestination(string2);
        this.setMessage(string3);
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Source", (String)string);
        this.source = string;
    }

    public String getDestination() {
        return this.destination;
    }

    public void setDestination(String string) {
        this.destination = string != null && string.trim().length() == 0 ? null : string;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Message", (String)string);
        this.message = string;
    }

    public String toString() {
        if (this.source == null) {
            throw new IllegalStateException("Source is null.");
        }
        if (this.message == null) {
            throw new IllegalStateException("Message is null.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.source);
        stringBuilder.append(SEPARATOR);
        if (this.destination != null) {
            stringBuilder.append(this.destination);
        }
        stringBuilder.append(SEPARATOR);
        stringBuilder.append(this.message);
        return stringBuilder.toString();
    }

    public static MulticastMessage parse(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Multicast Data", (String)string);
        String[] stringArray = string.split(SEPARATOR);
        if (stringArray.length < 3) {
            throw new IllegalArgumentException("Not valid multicast data.");
        }
        StringBuilder stringBuilder = new StringBuilder(stringArray[2]);
        for (int i = 3; i < stringArray.length; ++i) {
            stringBuilder.append(SEPARATOR);
            stringBuilder.append(stringArray[i]);
        }
        return new MulticastMessage(stringArray[0], stringArray[1], stringBuilder.toString());
    }
}

