/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.enterprise.core.busobj.AgentJobLog;
import java.io.File;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public class DefaultConfigPath {
    private static String DEFAULT_COMMON_PATH = null;
    private static String AGENT_MANAGER_DISPLAY_PATH = null;
    private static final String DEFAULT_FORMAT_YEAR = "%04d";
    private static final String DEFAULT_FORMAT = "%02d";
    public static final String DIR_NAME_HELPSYSTEMS = "Help Systems";
    public static final String DIR_NAME_AGENT = "Automate Schedule Agent";
    public static final String DIR_KNOWN_HOSTS = ".ssh";
    public static final String KNOWN_HOSTS = "known_hosts";
    public static final String TMP_DIRECTORY = "tmp";
    public static final String JOBLOGS_DIRECTORY = "JobLogs";

    public static void main(String[] stringArray) {
        Map<String, String> map = System.getenv();
        for (Map.Entry<String, String> object2 : map.entrySet()) {
            System.out.println(object2.getKey() + " --> " + object2.getValue());
        }
        System.out.println("Default Config Path: " + DefaultConfigPath.getDefaultPath());
        System.out.println("Default Config Path using default: " + DefaultConfigPath.getJobLogDirectory());
        System.out.println("Default Config Path using current time: " + DefaultConfigPath.getJobLogDirectoryDated(System.currentTimeMillis(), true));
        System.out.println("Default Config Path using 0: " + DefaultConfigPath.getJobLogDirectoryDated(0L, true));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(1, 2011);
        gregorianCalendar.set(2, 0);
        gregorianCalendar.set(5, 1);
        System.out.println("Default Config Path using 1/1/2011: " + DefaultConfigPath.getJobLogDirectoryDated(gregorianCalendar.getTimeInMillis(), true));
        System.out.println("Default Config known_hosts file location: " + DefaultConfigPath.getKnownHostsFile());
        String string = System.getProperty("os.version");
        int n = Integer.parseInt(string.substring(0, 1));
        System.out.println("operatingSystemVersion " + String.valueOf(n));
    }

    public static String getTempJobLogDirectory() {
        return TMP_DIRECTORY + File.separator + JOBLOGS_DIRECTORY;
    }

    public static String getJobLogDirectory() {
        return "entlogs" + File.separator + JOBLOGS_DIRECTORY;
    }

    public static String getKnownHostsDirectory() {
        return System.getProperty("user.home") + File.separator + DIR_KNOWN_HOSTS;
    }

    public static String getKnownHostsFile() {
        return DefaultConfigPath.getKnownHostsDirectory() + File.separator + KNOWN_HOSTS;
    }

    public static String getJobLogDirectoryDated(long l, boolean bl) {
        if (l > 0L) {
            Date date = null;
            GregorianCalendar gregorianCalendar = null;
            try {
                date = new Date(l);
                gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(date);
            }
            catch (Exception exception) {
                return DefaultConfigPath.getJobLogDirectory();
            }
            return DefaultConfigPath.getDateDirectory(gregorianCalendar, bl);
        }
        return DefaultConfigPath.getJobLogDirectory();
    }

    public static String getTempLogDirectory(boolean bl) {
        File file;
        if (bl && !(file = new File(DefaultConfigPath.getTempJobLogDirectory())).exists()) {
            file.mkdirs();
        }
        return DefaultConfigPath.getTempJobLogDirectory();
    }

    public static String getTempLogFile(String string, long l, String string2, String string3, String string4) {
        String string5 = string;
        String string6 = null;
        String string7 = AgentJobLog.getTempJobLogFileName((long)l, (String)string2, (String)string3, (String)string4);
        if (string5 == null) {
            string5 = DefaultConfigPath.getJobLogDirectory();
        }
        string6 = string5 + File.separator + string7;
        return string6;
    }

    private static String getDateDirectory(GregorianCalendar gregorianCalendar, boolean bl) {
        File file;
        StringBuffer stringBuffer = new StringBuffer();
        String string = DefaultConfigPath.getYearDirectory(gregorianCalendar);
        String string2 = DefaultConfigPath.getMonthDirectory(gregorianCalendar);
        String string3 = DefaultConfigPath.getDayDirectory(gregorianCalendar);
        stringBuffer.append(DefaultConfigPath.getJobLogDirectory());
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append(string3);
        if (bl && !(file = new File(stringBuffer.toString())).exists()) {
            file.mkdirs();
        }
        return stringBuffer.toString();
    }

    private static String getYearDirectory(GregorianCalendar gregorianCalendar) {
        return String.format(DEFAULT_FORMAT_YEAR, gregorianCalendar.get(1));
    }

    private static String getMonthDirectory(GregorianCalendar gregorianCalendar) {
        return String.format(DEFAULT_FORMAT, gregorianCalendar.get(2) + 1);
    }

    private static String getDayDirectory(GregorianCalendar gregorianCalendar) {
        return String.format(DEFAULT_FORMAT, gregorianCalendar.get(5));
    }

    public static String getDefaultPath() {
        if (DEFAULT_COMMON_PATH == null) {
            DefaultConfigPath.configDefaultPath();
        }
        return DEFAULT_COMMON_PATH;
    }

    public static String getDisplayPath() {
        if (AGENT_MANAGER_DISPLAY_PATH == null) {
            DefaultConfigPath.configDefaultPath();
        }
        return AGENT_MANAGER_DISPLAY_PATH;
    }

    public static String getServerDirectoryName(long l, boolean bl) {
        String string = null;
        if (l > 0L && DefaultConfigPath.directoryExists(string = DefaultConfigPath.getJobLogDirectoryDated(l, bl))) {
            return string;
        }
        string = DefaultConfigPath.getJobLogDirectory();
        if (!DefaultConfigPath.directoryExists(string)) {
            return null;
        }
        return string;
    }

    public static String getLogFile(String string, long l, String string2, String string3, long l2, boolean bl) {
        String string4 = string;
        String string5 = null;
        String string6 = AgentJobLog.getJobLogFileName((long)l, (String)string2, (String)string3);
        if (l2 > 0L) {
            if (string4 == null) {
                string4 = DefaultConfigPath.getJobLogDirectoryDated(l2, bl);
            }
            string5 = string4 + File.separator + string6;
            if (DefaultConfigPath.directoryExists(string4) && (bl || DefaultConfigPath.fileExists(string5))) {
                return string5;
            }
        }
        if (string4 == null) {
            string4 = DefaultConfigPath.getJobLogDirectory();
        }
        string5 = string4 + File.separator + string6;
        return string5;
    }

    public static boolean directoryExists(String string) {
        File file = new File(string);
        return file.exists() && file.isDirectory();
    }

    public static boolean fileExists(String string) {
        File file = new File(string);
        return file.exists();
    }

    private static void configDefaultPath() {
        try {
            String string;
            File file;
            DEFAULT_COMMON_PATH = "";
            AGENT_MANAGER_DISPLAY_PATH = "";
            String string2 = System.getenv("ALLUSERSPROFILE");
            if (string2 == null || string2.length() == 0) {
                DefaultConfigPath.sendDebugMsg("Environment variable 'ALLUSERSPROFILE' is null or blank.");
                return;
            }
            File file2 = new File(string2);
            if (!file2.exists()) {
                DefaultConfigPath.sendDebugMsg("Base path does not exist: " + file2.getAbsolutePath());
                return;
            }
            if (!file2.isDirectory()) {
                DefaultConfigPath.sendDebugMsg("Base path is not a directory: " + file2.getAbsolutePath());
                return;
            }
            String string3 = string2 + File.separator + "Application Data";
            File file3 = new File(string3);
            if (!file3.exists() || !file3.isDirectory()) {
                string3 = string2;
                file3 = new File(string3);
            }
            if (!file3.exists()) {
                file3.mkdir();
            }
            if ((file = new File(string = file3.getAbsolutePath() + File.separator + DIR_NAME_HELPSYSTEMS + File.separator + DIR_NAME_AGENT)).exists() && !file.isDirectory()) {
                DefaultConfigPath.sendDebugMsg("Common application path is not a directory: " + file.getAbsolutePath());
                return;
            }
            if (!file.exists() && !file.mkdirs()) {
                DefaultConfigPath.sendDebugMsg("Unable to create common application path: " + file.getAbsolutePath());
                return;
            }
            DEFAULT_COMMON_PATH = string;
            String string4 = System.getProperty("os.version");
            int n = Integer.parseInt(string4.substring(0, 1));
            AGENT_MANAGER_DISPLAY_PATH = n > 5 ? string2 + File.separator + DIR_NAME_HELPSYSTEMS + File.separator + DIR_NAME_AGENT : DEFAULT_COMMON_PATH;
        }
        catch (Throwable throwable) {
            DefaultConfigPath.sendDebugMsg("Error configuring application path.", throwable);
        }
    }

    private static void sendDebugMsg(String string) {
    }

    private static void sendDebugMsg(String string, Throwable throwable) {
    }
}

