/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.service.ServiceDescriptor;
import com.helpsystems.common.core.util.ValidationHelper;
import com.helpsystems.common.core.xml.ObjectPair;
import com.helpsystems.common.core.xml.XMLReflector;
import com.helpsystems.common.core.xml.XMLUtil;
import com.helpsystems.common.tl.HeavyweightPeerConfig;
import com.helpsystems.common.tl.PeerDescriptor;
import com.helpsystems.common.tl.module.ModuleDescriptor;
import com.helpsystems.enterprise.access.EnterpriseDatabase;
import com.helpsystems.enterprise.core.busobj.EnterpriseService;
import com.helpsystems.enterprise.core.db.JDBC_Descriptor_ID;
import com.helpsystems.enterprise.peer.AgentPeer;
import java.io.File;
import java.util.ArrayList;
import org.w3c.dom.Document;

public class AgentPeerConfig
extends HeavyweightPeerConfig {
    public static final String LOG_FILE_KEY = "log4j.appender.R.File";
    private static final long serialVersionUID = -4176313151785468558L;
    public static final int DEFAULT_NOTIFY_PORT = 7479;
    public static final int DEFAULT_WINDOWS_PROCESS_PORT = 7478;
    public static final String DEFAULT_MULTICAST_ADDRESS = "230.9.11.1";
    public static final int DEFAULT_MULTICAST_PORT = 7472;
    private static final String LOGGING_LEVEL = "log4j.rootLogger";
    public static final String DEFAULT_FILE_NAME = "agent.xml";
    private String licenseKey;
    private AgentMode mode;
    private ServiceType serviceType = ServiceType.UNDEFINED;
    private int localPort;
    private String multicastAddress;
    private int multicastPort;
    private PeerDescriptor master;
    private String multicastIdentifier;
    private int offlineEventHandling;
    private int windowsProcessPort;
    private boolean holdScheduler;
    private boolean holdAgents;
    private boolean modified;
    private PeerDescriptor standby;
    private String specifiedAgentName = null;
    private boolean allowDiagnosticRequests = true;
    private int semaphorePermits;

    public AgentPeerConfig() {
        this.mode = AgentMode.SERVER;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    public void setLicenseKey(String string) {
        this.licenseKey = string;
    }

    public AgentMode getMode() {
        return this.mode;
    }

    public void setMode(AgentMode agentMode) {
        this.mode = agentMode;
    }

    public String getModeAsString() {
        if (this.mode == null) {
            return "";
        }
        return this.mode.toString();
    }

    public ServiceType getServiceType() {
        return this.serviceType;
    }

    public void setServiceType(ServiceType serviceType) {
        this.serviceType = serviceType;
    }

    public void setModeAsString(String string) {
        if (AgentMode.SERVER.toString().equals(string)) {
            this.setMode(AgentMode.SERVER);
        } else if (AgentMode.CLIENT.toString().equals(string)) {
            this.setMode(AgentMode.CLIENT);
        } else if (AgentMode.SERVICE.toString().equals(string)) {
            this.setMode(AgentMode.SERVICE);
        } else if (AgentMode.STANDBY.toString().equals(string)) {
            this.setMode(AgentMode.STANDBY);
        } else {
            throw new IllegalArgumentException("Invalid mode: " + string);
        }
    }

    public PeerDescriptor getMaster() {
        return this.master;
    }

    public void setMaster(PeerDescriptor peerDescriptor) {
        this.master = peerDescriptor;
    }

    public String[] doNotInvoke() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : super.doNotInvoke()) {
            arrayList.add(string);
        }
        arrayList.add("getMode");
        arrayList.add("getServiceType");
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public int getNotifyPort() {
        if (this.localPort <= 0) {
            return 7479;
        }
        return this.localPort;
    }

    public void setNotifyPort(int n) {
        this.localPort = n;
    }

    public String getMulticastAddress() {
        if (this.multicastAddress == null || this.multicastAddress.trim().length() == 0) {
            return DEFAULT_MULTICAST_ADDRESS;
        }
        return this.multicastAddress;
    }

    public void setMulticastAddress(String string) {
        this.multicastAddress = string;
    }

    public int getMulticastPort() {
        if (this.multicastPort <= 0) {
            return 7472;
        }
        return this.multicastPort;
    }

    public void setMulticastPort(int n) {
        ValidationHelper.validateBounds((String)"Multicast Port", (long)0L, (long)65535L, (long)n);
        this.multicastPort = n;
    }

    public String getMulticastIdentifier() {
        return this.multicastIdentifier;
    }

    public void setMulticastIdentifier(String string) {
        ValidationHelper.checkForNullAndBlank((String)"Multicast Identifier", (String)string);
        this.multicastIdentifier = string;
    }

    public int getOfflineEventHandling() {
        return this.offlineEventHandling;
    }

    public void setOfflineEventHandling(int n) {
        switch (n) {
            case 0: 
            case 1: {
                this.offlineEventHandling = n;
                return;
            }
        }
        throw new IllegalArgumentException("Invalid setting: " + n);
    }

    public int getWindowsProcessPort() {
        return this.windowsProcessPort;
    }

    public void setWindowsProcessPort(int n) {
        this.windowsProcessPort = n;
    }

    public void setHoldScheduler(boolean bl) {
        this.holdScheduler = bl;
    }

    public boolean getHoldScheduler() {
        return this.holdScheduler;
    }

    public void setHoldAgents(boolean bl) {
        this.holdAgents = bl;
    }

    public boolean getHoldAgents() {
        return this.holdAgents;
    }

    public String getSpecifiedAgentName() {
        return this.specifiedAgentName;
    }

    public void setSpecifiedAgentName(String string) {
        this.specifiedAgentName = string;
    }

    public boolean getAllowDiagnosticRequests() {
        return this.isAllowDiagnosticRequests();
    }

    public boolean isAllowDiagnosticRequests() {
        return this.allowDiagnosticRequests;
    }

    public void setAllowDiagnosticRequests(boolean bl) {
        this.allowDiagnosticRequests = bl;
    }

    public int getSemaphorePermits() {
        return this.semaphorePermits;
    }

    public void setSemaphorePermits(int n) {
        this.semaphorePermits = n;
    }

    public static AgentPeerConfig getDefaultAgentPeer() {
        AgentPeerConfig agentPeerConfig = new AgentPeerConfig();
        agentPeerConfig.setMode(AgentMode.CLIENT);
        agentPeerConfig.setNotifyPort(7479);
        agentPeerConfig.setMulticastAddress(DEFAULT_MULTICAST_ADDRESS);
        agentPeerConfig.setMulticastPort(7472);
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(6);
        peerDescriptor.setPort(7472);
        agentPeerConfig.setMaster(peerDescriptor);
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        moduleDescriptor.setProductName("transport");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor);
        ModuleDescriptor moduleDescriptor2 = new ModuleDescriptor();
        moduleDescriptor2.setProductName("schent-mp");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor2);
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)LOGGING_LEVEL, (Object)"INFO,R"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout.ConversionPattern", (Object)"%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)LOG_FILE_KEY, (Object)"logs/agent.log"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout", (Object)"org.apache.log4j.PatternLayout"));
        return agentPeerConfig;
    }

    public static AgentPeerConfig getDefaultServicePeer(EnterpriseService enterpriseService) {
        AgentPeerConfig agentPeerConfig = new AgentPeerConfig();
        agentPeerConfig.setMode(AgentMode.SERVICE);
        agentPeerConfig.setNotifyPort(7479);
        agentPeerConfig.setMulticastAddress(DEFAULT_MULTICAST_ADDRESS);
        agentPeerConfig.setMulticastPort(7472);
        agentPeerConfig.setListenPort(enterpriseService.getServicePort());
        PeerDescriptor peerDescriptor = new PeerDescriptor();
        peerDescriptor.setType(6);
        peerDescriptor.setPort(7472);
        agentPeerConfig.setMaster(peerDescriptor);
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        moduleDescriptor.setProductName("transport");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor);
        ModuleDescriptor moduleDescriptor2 = new ModuleDescriptor();
        moduleDescriptor2.setProductName("schent-mp");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor2);
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.PRODUCTION));
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.TEST));
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.DEVELOPMENT));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)LOGGING_LEVEL, (Object)"INFO,R"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout.ConversionPattern", (Object)"%d{yyyy-MM-dd HH:mm:ss,SSS} %5p [%t] - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)LOG_FILE_KEY, (Object)enterpriseService.getServiceLogFileName()));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.R.layout", (Object)"org.apache.log4j.PatternLayout"));
        return agentPeerConfig;
    }

    public static AgentPeerConfig getDefaultServerPeer() {
        AgentPeerConfig agentPeerConfig = new AgentPeerConfig();
        agentPeerConfig.setMode(AgentMode.SERVER);
        agentPeerConfig.setListenPort(AgentPeer.DEFAULT_SERVER_PORT);
        ModuleDescriptor moduleDescriptor = new ModuleDescriptor();
        moduleDescriptor.setProductName("transport");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor);
        ModuleDescriptor moduleDescriptor2 = new ModuleDescriptor();
        moduleDescriptor2.setProductName("schent-mp");
        agentPeerConfig.addModuleDescriptor(moduleDescriptor2);
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.File", (Object)".\\entlogs\\Enterprise\\enterprise_root.log"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.layout", (Object)"org.apache.log4j.PatternLayout"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.layout.ConversionPattern", (Object)"%d %-5p %-18t %-30c{1} - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.ROOT.Encoding", (Object)"UTF-8"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.File", (Object)".\\entlogs\\Enterprise\\enterprise_scheduler.log"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.layout", (Object)"org.apache.log4j.PatternLayout"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.layout.ConversionPattern", (Object)"%d %-5p %-18t %-30c{1} - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SCHEDULER.Encoding", (Object)"UTF-8"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER", (Object)"org.apache.log4j.RollingFileAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.MaxBackupIndex", (Object)"5"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.File", (Object)".\\entlogs\\Enterprise\\enterprise_server.log"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.Append", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.MaxFileSize", (Object)"20480KB"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.layout", (Object)"org.apache.log4j.PatternLayout"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.layout.ConversionPattern", (Object)"%d %-5p %-18t %-30c{1} - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.ImmediateFlush", (Object)"true"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.SERVER.Encoding", (Object)"UTF-8"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.CONSOLE", (Object)"org.apache.log4j.ConsoleAppender"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.CONSOLE.layout", (Object)"org.apache.log4j.PatternLayout"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)"log4j.appender.CONSOLE.layout.ConversionPattern", (Object)"%d %-5p %-18t %-30c{1} - %m%n"));
        agentPeerConfig.addLog4jSetting(new ObjectPair((Object)LOGGING_LEVEL, (Object)"INFO,ROOT,SERVER,SCHEDULER"));
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.PRODUCTION));
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.TEST));
        agentPeerConfig.addServiceDescriptor((ServiceDescriptor)EnterpriseDatabase.createDefaultJDBCServiceDescriptor((JDBC_Descriptor_ID)JDBC_Descriptor_ID.DEVELOPMENT));
        return agentPeerConfig;
    }

    public static void buildDefaultServerPeerXML(int n, String string) {
        AgentPeerConfig agentPeerConfig = null;
        boolean bl = false;
        try {
            File file = new File(string);
            if (file.exists()) {
                Document document = XMLUtil.loadXML((String)file.getAbsolutePath());
                agentPeerConfig = (AgentPeerConfig)((Object)XMLReflector.readObject((Document)document));
                System.out.println("Server config file '" + file.getAbsolutePath() + "' was loaded.");
            } else {
                System.out.println("Server config file '" + file.getAbsolutePath() + "' was not found.  Creating default file.");
                agentPeerConfig = AgentPeerConfig.getDefaultServerPeer();
                bl = true;
            }
            if (n != 0 && n != agentPeerConfig.getListenPort()) {
                agentPeerConfig.setListenPort(n);
                bl = true;
            } else {
                System.out.println("File did not require changes.");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (bl) {
            try {
                XMLUtil.writeObjectToFile(agentPeerConfig, (String)string);
                System.out.println("Saved config to " + string + ".");
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public String findLoggingLevel() {
        ObjectPair[] objectPairArray = this.getLog4jSettings();
        if (objectPairArray == null) {
            return null;
        }
        for (ObjectPair objectPair : objectPairArray) {
            String[] stringArray;
            if (!LOGGING_LEVEL.equals(objectPair.getKey()) || (stringArray = objectPair.getValue().toString().split(",")).length <= 0) continue;
            return stringArray[0].toUpperCase();
        }
        return null;
    }

    public static void main(String[] stringArray) {
        String string = "/helpsys/schent-mp/trunk/gui/config/entServer.xml";
        AgentPeerConfig.buildDefaultServerPeerXML(7472, string);
        System.exit(0);
    }

    public void setModified(boolean bl) {
        this.modified = bl;
    }

    public boolean isModified() {
        return this.modified;
    }

    public PeerDescriptor getStandby() {
        return this.standby;
    }

    public void setStandby(PeerDescriptor peerDescriptor) {
        this.standby = peerDescriptor;
    }

    public static enum ServiceType {
        UNDEFINED,
        REPORTRUNNER;

    }

    public static enum AgentMode {
        SERVER,
        CLIENT,
        SERVICE,
        STANDBY;

    }
}

