/*
 * Decompiled with CFR 0.152.
 */
package com.helpsystems.enterprise.peer;

import com.helpsystems.common.core.util.RelMod;
import com.helpsystems.enterprise.core.busobj.EnterpriseVersionedObject;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public class AgentCredentials
extends EnterpriseVersionedObject {
    private static final long serialVersionUID = -6643906651353085789L;
    public static final String SKYBOT_AGENT_NAME = "SKYBOT_AGENT_NAME";
    private Properties env;
    private Properties props;
    private int cpuCount;
    private RelMod schentRelMod;
    private String agentTZ;
    private String agentSpecifiedName;

    public AgentCredentials() {
        Map<String, String> map = System.getenv();
        this.env = new Properties();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            this.env.setProperty(entry.getKey(), entry.getValue());
        }
        this.props = System.getProperties();
        Runtime runtime = Runtime.getRuntime();
        this.cpuCount = runtime.availableProcessors();
        this.agentTZ = TimeZone.getDefault().getID();
    }

    public String getenv(String string) {
        return this.env.getProperty(string);
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public int getCpuCount() {
        return this.cpuCount;
    }

    public RelMod getSchentRelMod() {
        return this.schentRelMod;
    }

    public void setSchentRelMod(RelMod relMod) {
        this.schentRelMod = relMod;
    }

    public String getAgentTZ() {
        return this.agentTZ;
    }

    public void setAgentTZ(String string) {
        this.agentTZ = string;
    }

    public String getAgentSpecifiedName() {
        return this.agentSpecifiedName;
    }

    public void setAgentSpecifiedName(String string) {
        this.agentSpecifiedName = string;
        if (this.agentSpecifiedName != null) {
            this.agentSpecifiedName = this.agentSpecifiedName.replaceAll(" ", "_").trim();
        }
    }

    public void loadDefaultAgentSpecifiedName() {
        String string = System.getenv(SKYBOT_AGENT_NAME);
        if (string != null) {
            this.setAgentSpecifiedName(string);
        }
    }

    void setProperty(String string, String string2) {
        this.props.setProperty(string, string2);
    }
}

