/*
 * Decompiled with CFR 0.152.
 */
package textchange;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.apache.log4j.PropertyConfigurator;

public class TextChange {
    private static String OUTFILE_KEY;
    private static int changedLines;
    static /* synthetic */ Class class$textchange$TextChange;
    private static Logger logger;
    private static int totalLines;
    private static int whichSearchMethod;

    static {
        logger = Logger.getLogger((Class)(class$textchange$TextChange == null ? (class$textchange$TextChange = TextChange.class$("textchange.TextChange")) : class$textchange$TextChange));
        OUTFILE_KEY = "outfile";
        totalLines = 0;
        changedLines = 0;
        whichSearchMethod = 14;
        try {
            "".replaceAll("", "");
        }
        catch (NoSuchMethodError err) {
            whichSearchMethod = 13;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static String getDottedIpaddressWithPort(String port) {
        String localhost;
        block3: {
            localhost = "unknown";
            try {
                InetAddress addr = InetAddress.getLocalHost();
                if (port.equalsIgnoreCase("80")) {
                    localhost = addr.getHostAddress();
                    break block3;
                }
                localhost = addr.getHostAddress() + ":" + port;
            }
            catch (Exception ex) {
                logger.info((Object)"getDottedIpaddressWithPort exception");
            }
        }
        return localhost;
    }

    public static void main(String[] args) {
        if (args.length == 5) {
            TextChange.startLogging("ON");
        } else {
            TextChange.startLogging("OFF");
        }
        int i = 0;
        while (i < args.length) {
            logger.info((Object)("arg" + i + " " + args[i]));
            ++i;
        }
        if (args.length < 4) {
            logger.info((Object)("textchange called with " + args.length + " args, need 4 or more args to run."));
            System.exit(0);
        }
        try {
            String filename = args[0];
            String backupFilename = args[1];
            String pattern = args[2];
            String replaceText = args[3];
            if (args.length == 6) {
                replaceText = TextChange.getDottedIpaddressWithPort(args[5]);
            }
            TextChange.replace(filename, backupFilename, pattern, replaceText);
            logger.info((Object)("changed lines " + changedLines));
            logger.info((Object)("total   lines " + totalLines));
            System.exit(0);
        }
        catch (Exception e) {
            logger.error((Object)"Exception", (Throwable)e);
        }
    }

    public static void replace(String filename, String backupFilename, String pattern, String replaceText) throws IOException {
        if (filename == null) {
            throw new NullPointerException("The filename passed in was null.");
        }
        if (replaceText == null) {
            replaceText = "";
        }
        File sourceFile = new File(filename);
        BufferedReader reader = new BufferedReader(new FileReader(sourceFile));
        Vector<String> v = new Vector<String>();
        String line = null;
        String modLine = null;
        while ((line = reader.readLine()) != null) {
            if (whichSearchMethod == 14) {
                modLine = line.replaceAll(pattern, replaceText);
                if (modLine.compareTo(line) != 0) {
                    ++changedLines;
                }
                v.add(modLine);
            } else {
                modLine = TextChange.searchAndReplace(line, pattern, replaceText);
                if (modLine.compareTo(line) != 0) {
                    ++changedLines;
                }
                v.add(modLine);
            }
            ++totalLines;
        }
        reader.close();
        if (backupFilename != null) {
            File backupfile = new File(backupFilename);
            backupfile.delete();
            sourceFile.renameTo(backupfile);
        }
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(filename)));
        Iterator iterator = v.iterator();
        while (iterator.hasNext()) {
            line = (String)iterator.next();
            writer.println(line);
        }
        writer.close();
    }

    public static String searchAndReplace(String s, String find, String replace) {
        if (s == null) {
            return null;
        }
        if (replace == null) {
            replace = "";
        }
        StringBuffer sb = new StringBuffer(s);
        int nextMatch = -1;
        while (nextMatch < sb.length()) {
            if ((nextMatch = s.indexOf(find, nextMatch)) == -1) break;
            sb.replace(nextMatch, nextMatch + find.length(), replace);
            s = sb.toString();
            nextMatch += find.length();
        }
        return sb.toString();
    }

    private static void startLogging(String mylogging) {
        Properties props = new Properties();
        props.setProperty("log4j.rootLogger", mylogging + ", " + OUTFILE_KEY);
        props.setProperty("log4j.appender.outfile", "org.apache.log4j.RollingFileAppender");
        props.setProperty("log4j.appender.outfile.File", "textchange.log");
        props.setProperty("log4j.appender.outfile.Append", "true");
        props.setProperty("log4j.appender.outfile.layout.ConversionPattern", "%d %-5p %-12t %-35c{1} - %m%n");
        props.setProperty("log4j.appender.outfile.MaxBackupIndex", "1");
        props.setProperty("log4j.appender.outfile.layout", "org.apache.log4j.PatternLayout");
        props.setProperty("log4j.appender.outfile.MaxFileSize", "2048KB");
        props.setProperty("log4j.appender.outfile.ImmediateFlush", "true");
        PropertyConfigurator.configure((Properties)props);
    }
}

